"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationFinalizationResult = exports.FinalizeAlertsMigrationResponse = exports.FinalizeAlertsMigrationRequestBody = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Finalize alerts migration API endpoint
 *   version: 2023-10-31
 */

const MigrationFinalizationResult = exports.MigrationFinalizationResult = _zod.z.object({
  id: _zod.z.string(),
  completed: _zod.z.boolean(),
  destinationIndex: _zod.z.string(),
  status: _zod.z.enum(['success', 'failure', 'pending']),
  sourceIndex: _zod.z.string(),
  version: _zod.z.string(),
  updated: _zod.z.string().datetime(),
  error: _zod.z.object({
    message: _zod.z.string(),
    status_code: _zod.z.number().int()
  }).optional()
});
const FinalizeAlertsMigrationRequestBody = exports.FinalizeAlertsMigrationRequestBody = _zod.z.object({
  /**
   * Array of `migration_id`s to finalize.
   */
  migration_ids: _zod.z.array(_zod.z.string()).min(1)
});
const FinalizeAlertsMigrationResponse = exports.FinalizeAlertsMigrationResponse = _zod.z.array(MigrationFinalizationResult);