"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimestampOverrideFallbackDisabled = exports.TimestampOverride = exports.TimelineTemplateTitle = exports.TimelineTemplateId = exports.ThreatTechnique = exports.ThreatTactic = exports.ThreatSubtechnique = exports.ThreatArray = exports.Threat = exports.SeverityMapping = exports.SeverityEnum = exports.Severity = exports.SetupGuide = exports.SavedQueryId = exports.SavedObjectResolveOutcomeEnum = exports.SavedObjectResolveOutcome = exports.SavedObjectResolveAliasTargetId = exports.SavedObjectResolveAliasPurposeEnum = exports.SavedObjectResolveAliasPurpose = exports.RuleVersion = exports.RuleTagArray = exports.RuleSource = exports.RuleSignatureId = exports.RuleRevision = exports.RuleReferenceArray = exports.RuleQuery = exports.RuleObjectId = exports.RuleNameOverride = exports.RuleName = exports.RuleMetadata = exports.RuleLicense = exports.RuleIntervalTo = exports.RuleIntervalFrom = exports.RuleInterval = exports.RuleFilterArray = exports.RuleFalsePositiveArray = exports.RuleExceptionList = exports.RuleDescription = exports.RuleAuthorArray = exports.RuleActionThrottle = exports.RuleActionParams = exports.RuleActionNotifyWhenEnum = exports.RuleActionNotifyWhen = exports.RuleActionId = exports.RuleActionGroup = exports.RuleActionFrequency = exports.RuleActionAlertsFilter = exports.RuleAction = exports.RiskScoreMapping = exports.RiskScore = exports.RequiredFieldInput = exports.RequiredFieldArray = exports.RequiredField = exports.RelatedIntegrationArray = exports.RelatedIntegration = exports.QueryLanguageEnum = exports.QueryLanguage = exports.MaxSignals = exports.KqlQueryLanguageEnum = exports.KqlQueryLanguage = exports.IsRuleImmutable = exports.IsRuleEnabled = exports.IsExternalRuleCustomized = exports.InvestigationGuide = exports.InvestigationFields = exports.InternalRuleSource = exports.IndexPatternArray = exports.GapFillStatusEnum = exports.GapFillStatus = exports.ExternalRuleSource = exports.ExternalRuleHasBaseVersion = exports.ExternalRuleCustomizedFields = exports.ExceptionListTypeEnum = exports.ExceptionListType = exports.DataViewId = exports.BuildingBlockType = exports.AlertsIndexNamespace = exports.AlertsIndex = exports.AlertSuppressionMissingFieldsStrategyEnum = exports.AlertSuppressionMissingFieldsStrategy = exports.AlertSuppressionGroupBy = exports.AlertSuppressionDurationUnitEnum = exports.AlertSuppressionDurationUnit = exports.AlertSuppressionDuration = exports.AlertSuppressionCamel = exports.AlertSuppression = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _primitives = require("../../../model/primitives.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Rule Attributes
 *   version: not applicable
 */

/**
 * A dynamic unique identifier for the rule object. It is randomly generated when a rule is created and cannot be changed after that. It is always a UUID. It is unique within a given Kibana space. The same prebuilt Elastic rule, when installed in two different Kibana spaces or two different Elastic environments, will have different object `id`s.
 */

const RuleObjectId = exports.RuleObjectId = _primitives.UUID;

/**
 * A stable unique identifier for the rule object. It can be assigned during rule creation. It can be any string, but often is a UUID. It should be unique not only within a given Kibana space, but also across spaces and Elastic environments. The same prebuilt Elastic rule, when installed in two different Kibana spaces or two different Elastic environments, will have the same `rule_id`s.
 */

const RuleSignatureId = exports.RuleSignatureId = _zod.z.string();

/**
 * A human-readable name for the rule.
 */

const RuleName = exports.RuleName = _zod.z.string().min(1);

/**
 * The rule’s description.
 */

const RuleDescription = exports.RuleDescription = _zod.z.string().min(1);

/**
  * The rule's version number.

- For prebuilt rules it represents the version of the rule's content in the source [detection-rules](https://github.com/elastic/detection-rules) repository (and the corresponding `security_detection_engine` Fleet package that is used for distributing prebuilt rules). 
- For custom rules it is set to `1` when the rule is created. 
> info
> It is not incremented on each update. Compare this to the `revision` field.

  */

const RuleVersion = exports.RuleVersion = _zod.z.number().int().min(1);

/**
  * The rule's revision number.

It represents the version of rule's object in Kibana. It is set to `0` when the rule is installed or created and then gets incremented on each update.
> info
> Not all updates to any rule fields will increment the revision. Only those fields that are considered static `rule parameters` can trigger revision increments. For example, an update to a rule's query or index fields will increment the rule's revision by `1`. However, changes to dynamic or technical fields like enabled or execution_summary will not cause revision increments.

  */

const RuleRevision = exports.RuleRevision = _zod.z.number().int().min(0);
const QueryLanguage = exports.QueryLanguage = _zod.z.enum(['kuery', 'lucene', 'eql', 'esql']);
const QueryLanguageEnum = exports.QueryLanguageEnum = QueryLanguage.enum;
const KqlQueryLanguage = exports.KqlQueryLanguage = _zod.z.enum(['kuery', 'lucene']);
const KqlQueryLanguageEnum = exports.KqlQueryLanguageEnum = KqlQueryLanguage.enum;

/**
 * This field determines whether the rule is a prebuilt Elastic rule. It will be replaced with the `rule_source` field.
 * @deprecated
 */

const IsRuleImmutable = exports.IsRuleImmutable = _zod.z.boolean();

/**
 * Determines whether an external/prebuilt rule has been customized by the user (i.e. any of its fields have been modified and diverged from the base value).
 */

const IsExternalRuleCustomized = exports.IsExternalRuleCustomized = _zod.z.boolean();

/**
 * Determines whether an external/prebuilt rule has its original, unmodified version present when the calculation of its customization status is performed (`rule_source.is_customized` and `rule_source.customized_fields`).
 */

const ExternalRuleHasBaseVersion = exports.ExternalRuleHasBaseVersion = _zod.z.boolean();

/**
 * An array of customized field names — that is, fields that the user has modified from their base value. Defaults to an empty array.
 */

const ExternalRuleCustomizedFields = exports.ExternalRuleCustomizedFields = _zod.z.array(_zod.z.object({
  /**
   * Name of a user-modified field in the rule object.
   */
  field_name: _zod.z.string()
}));

/**
 * Type of rule source for internally sourced rules, i.e. created within the Kibana apps.
 */

const InternalRuleSource = exports.InternalRuleSource = _zod.z.object({
  type: _zod.z.literal('internal')
});

/**
 * Type of rule source for externally sourced rules, i.e. rules that have an external source, such as the Elastic Prebuilt rules repo.
 */

const ExternalRuleSource = exports.ExternalRuleSource = _zod.z.object({
  type: _zod.z.literal('external'),
  is_customized: IsExternalRuleCustomized,
  has_base_version: ExternalRuleHasBaseVersion,
  customized_fields: ExternalRuleCustomizedFields
});

/**
 * Discriminated union that determines whether the rule is internally sourced (created within the Kibana app) or has an external source, such as the Elastic Prebuilt rules repo.
 */

const RuleSource = exports.RuleSource = _zod.z.discriminatedUnion('type', [ExternalRuleSource, InternalRuleSource]);

/**
 * Determines whether the rule is enabled. Defaults to true.
 */

const IsRuleEnabled = exports.IsRuleEnabled = _zod.z.boolean();

/**
 * Frequency of rule execution, using a date math range. For example, "1h" means the rule runs every hour. Defaults to 5m (5 minutes).
 */

const RuleInterval = exports.RuleInterval = _zod.z.string();

/**
 * Time from which data is analyzed each time the rule runs, using a date math range. For example, now-4200s means the rule analyzes data from 70 minutes before its start time. Defaults to now-6m (analyzes data from 6 minutes before the start time).
 */

const RuleIntervalFrom = exports.RuleIntervalFrom = _zod.z.string().superRefine(_zodHelpers.isValidDateMath);
const RuleIntervalTo = exports.RuleIntervalTo = _zod.z.string();

/**
  * A numerical representation of the alert's severity from 0 to 100, where:
* `0` - `21` represents low severity
* `22` - `47` represents medium severity
* `48` - `73` represents high severity
* `74` - `100` represents critical severity

  */

const RiskScore = exports.RiskScore = _zod.z.number().int().min(0).max(100);

/**
 * Overrides generated alerts' risk_score with a value from the source event
 */

const RiskScoreMapping = exports.RiskScoreMapping = _zod.z.array(_zod.z.object({
  /**
   * Source event field used to override the default `risk_score`.
   */
  field: _zod.z.string(),
  operator: _zod.z.literal('equals'),
  value: _zod.z.string(),
  risk_score: RiskScore.optional()
}));

/**
  * Severity level of alerts produced by the rule, which must be one of the following:
* `low`: Alerts that are of interest but generally not considered to be security incidents
* `medium`: Alerts that require investigation
* `high`: Alerts that require immediate investigation
* `critical`: Alerts that indicate it is highly likely a security incident has occurred

  */

const Severity = exports.Severity = _zod.z.enum(['low', 'medium', 'high', 'critical']);
const SeverityEnum = exports.SeverityEnum = Severity.enum;

/**
 * Overrides generated alerts' severity with values from the source event
 */

const SeverityMapping = exports.SeverityMapping = _zod.z.array(_zod.z.object({
  /**
   * Source event field used to override the default `severity`.
   */
  field: _zod.z.string(),
  operator: _zod.z.literal('equals'),
  severity: Severity,
  value: _zod.z.string()
}));

/**
 * String array containing words and phrases to help categorize, filter, and search rules. Defaults to an empty array.
 */

const RuleTagArray = exports.RuleTagArray = _zod.z.array(_zod.z.string());

/**
  * Placeholder for metadata about the rule.
> info
> This field is overwritten when you save changes to the rule’s settings.

  */

const RuleMetadata = exports.RuleMetadata = _zod.z.object({}).catchall(_zod.z.unknown());

/**
 * The rule's license.
 */

const RuleLicense = exports.RuleLicense = _zod.z.string();

/**
 * The rule’s author.
 */

const RuleAuthorArray = exports.RuleAuthorArray = _zod.z.array(_zod.z.string());

/**
 * String array used to describe common reasons why the rule may issue false-positive alerts. Defaults to an empty array.
 */

const RuleFalsePositiveArray = exports.RuleFalsePositiveArray = _zod.z.array(_zod.z.string());

/**
 * Array containing notes about or references to relevant information about the rule. Defaults to an empty array.
 */

const RuleReferenceArray = exports.RuleReferenceArray = _zod.z.array(_zod.z.string());

/**
 * Notes to help investigate alerts produced by the rule.
 */

const InvestigationGuide = exports.InvestigationGuide = _zod.z.string();

/**
 * Populates the rule’s setup guide with instructions on rule prerequisites such as required integrations, configuration steps, and anything else needed for the rule to work correctly.
 */

const SetupGuide = exports.SetupGuide = _zod.z.string();

/**
  * Determines if the rule acts as a building block. If yes, the value must be `default`.
By default, building-block alerts are not displayed in the UI. These rules are used as a foundation for other rules that do generate alerts.
For more information, refer to [About building block rules](https://www.elastic.co/guide/en/security/current/building-block-rule.html).

  */

const BuildingBlockType = exports.BuildingBlockType = _zod.z.string();

/**
 * (deprecated) Has no effect.
 * @deprecated
 */

const AlertsIndex = exports.AlertsIndex = _zod.z.string();

/**
 * Has no effect.
 */

const AlertsIndexNamespace = exports.AlertsIndexNamespace = _zod.z.string();

/**
  * Maximum number of alerts the rule can create during a single run (the rule’s Max alerts per run [advanced setting](https://www.elastic.co/guide/en/security/current/rules-ui-create.html#rule-ui-advanced-params) value).
> info
> This setting can be superseded by the [Kibana configuration setting](https://www.elastic.co/guide/en/kibana/current/alert-action-settings-kb.html#alert-settings) `xpack.alerting.rules.run.alerts.max`, which determines the maximum alerts generated by any rule in the Kibana alerting framework. For example, if `xpack.alerting.rules.run.alerts.max` is set to 1000, the rule can generate no more than 1000 alerts even if `max_signals` is set higher.

  */

const MaxSignals = exports.MaxSignals = _zod.z.number().int().min(1).default(100);
const ThreatSubtechnique = exports.ThreatSubtechnique = _zod.z.object({
  /**
   * Subtechnique ID
   */
  id: _zod.z.string(),
  /**
   * Subtechnique name
   */
  name: _zod.z.string(),
  /**
   * Subtechnique reference
   */
  reference: _zod.z.string()
});
const ThreatTechnique = exports.ThreatTechnique = _zod.z.object({
  /**
   * Technique ID
   */
  id: _zod.z.string(),
  /**
   * Technique name
   */
  name: _zod.z.string(),
  /**
   * Technique reference
   */
  reference: _zod.z.string(),
  /** 
      * Array containing more specific information on the attack technique.
        */
  subtechnique: _zod.z.array(ThreatSubtechnique).optional()
});

/**
  * Object containing information on the attack type

  */

const ThreatTactic = exports.ThreatTactic = _zod.z.object({
  /**
   * Tactic ID
   */
  id: _zod.z.string(),
  /**
   * Tactic name
   */
  name: _zod.z.string(),
  /**
   * Tactic reference
   */
  reference: _zod.z.string()
});

/**
  * > info
> Currently, only threats described using the MITRE ATT&CK&trade; framework are supported.

  */

const Threat = exports.Threat = _zod.z.object({
  /**
   * Relevant attack framework
   */
  framework: _zod.z.string(),
  tactic: ThreatTactic,
  /**
   * Array containing information on the attack techniques (optional)
   */
  technique: _zod.z.array(ThreatTechnique).optional()
});
const ThreatArray = exports.ThreatArray = _zod.z.array(Threat);

/**
  * Indices on which the rule functions. Defaults to the Security Solution indices defined on the Kibana Advanced Settings page (Kibana → Stack Management → Advanced Settings → `securitySolution:defaultIndex`).
> info
> This field is not supported for ES|QL rules.

  */

const IndexPatternArray = exports.IndexPatternArray = _zod.z.array(_zod.z.string());
const DataViewId = exports.DataViewId = _zod.z.string();

/**
 * Kibana [saved search](https://www.elastic.co/guide/en/kibana/current/save-open-search.html) used by the rule to create alerts.
 */

const SavedQueryId = exports.SavedQueryId = _zod.z.string();

/**
  * [Query](https://www.elastic.co/guide/en/kibana/8.17/search.html) used by the rule to create alerts.

- For indicator match rules, only the query’s results are used to determine whether an alert is generated.
- ES|QL rules have additional query requirements. Refer to [Create ES|QL](https://www.elastic.co/guide/en/security/current/rules-ui-create.html#create-esql-rule) rules for more information.

  */

const RuleQuery = exports.RuleQuery = _zod.z.string();

/**
  * The query and filter context array used to define the conditions for when alerts are created from events. Defaults to an empty array.
> info
> This field is not supported for ES|QL rules.

  */

const RuleFilterArray = exports.RuleFilterArray = _zod.z.array(_zod.z.unknown());

/**
 * Sets which field in the source event is used to populate the alert's `signal.rule.name` value (in the UI, this value is displayed on the Rules page in the Rule column). When unspecified, the rule’s `name` value is used. The source field must be a string data type.
 */

const RuleNameOverride = exports.RuleNameOverride = _zod.z.string();

/**
 * Sets the time field used to query indices. When unspecified, rules query the `@timestamp` field. The source field must be an Elasticsearch date data type.
 */

const TimestampOverride = exports.TimestampOverride = _zod.z.string();

/**
 * Disables the fallback to the event's @timestamp field
 */

const TimestampOverrideFallbackDisabled = exports.TimestampOverrideFallbackDisabled = _zod.z.boolean();

/**
  * Describes an Elasticsearch field that is needed for the rule to function.

Almost all types of Security rules check source event documents for a match to some kind of
query or filter. If a document has certain field with certain values, then it's a match and
the rule will generate an alert.

Required field is an event field that must be present in the source indices of a given rule.

@example
const standardEcsField: RequiredField = {
  name: 'event.action',
  type: 'keyword',
  ecs: true,
};

@example
const nonEcsField: RequiredField = {
  name: 'winlog.event_data.AttributeLDAPDisplayName',
  type: 'keyword',
  ecs: false,
};

  */

const RequiredField = exports.RequiredField = _zod.z.object({
  /**
   * Name of an Elasticsearch field
   */
  name: _zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString),
  /**
   * Type of the Elasticsearch field
   */
  type: _zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString),
  /**
   * Indicates whether the field is ECS-compliant. This property is only present in responses. Its value is computed based on field’s name and type.
   */
  ecs: _zod.z.boolean()
});

/**
 * Input parameters to create a RequiredField. Does not include the `ecs` field, because `ecs` is calculated on the backend based on the field name and type.
 */

const RequiredFieldInput = exports.RequiredFieldInput = _zod.z.object({
  /**
   * Name of an Elasticsearch field
   */
  name: _zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString),
  /**
   * Type of the Elasticsearch field
   */
  type: _zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString)
});
const RequiredFieldArray = exports.RequiredFieldArray = _zod.z.array(RequiredField);

/**
 * Timeline template ID
 */

const TimelineTemplateId = exports.TimelineTemplateId = _zod.z.string();

/**
 * Timeline template title
 */

const TimelineTemplateTitle = exports.TimelineTemplateTitle = _zod.z.string();
const SavedObjectResolveOutcome = exports.SavedObjectResolveOutcome = _zod.z.enum(['exactMatch', 'aliasMatch', 'conflict']);
const SavedObjectResolveOutcomeEnum = exports.SavedObjectResolveOutcomeEnum = SavedObjectResolveOutcome.enum;
const SavedObjectResolveAliasTargetId = exports.SavedObjectResolveAliasTargetId = _zod.z.string();
const SavedObjectResolveAliasPurpose = exports.SavedObjectResolveAliasPurpose = _zod.z.enum(['savedObjectConversion', 'savedObjectImport']);
const SavedObjectResolveAliasPurposeEnum = exports.SavedObjectResolveAliasPurposeEnum = SavedObjectResolveAliasPurpose.enum;

/**
  * Related integration is a potential dependency of a rule. It's assumed that if the user installs
one of the related integrations of a rule, the rule might start to work properly because it will
have source events (generated by this integration) potentially matching the rule's query.

NOTE: Proper work is not guaranteed, because a related integration, if installed, can be
configured differently or generate data that is not necessarily relevant for this rule.

Related integration is a combination of a Fleet package and (optionally) one of the
package's "integrations" that this package contains. It is represented by 3 properties:

- `package`: name of the package (required, unique id)
- `version`: version of the package (required, semver-compatible)
- `integration`: name of the integration of this package (optional, id within the package)

There are Fleet packages like `windows` that contain only one integration; in this case,
`integration` should be unspecified. There are also packages like `aws` and `azure` that contain
several integrations; in this case, `integration` should be specified.

  */

const RelatedIntegration = exports.RelatedIntegration = _zod.z.object({
  package: _primitives.NonEmptyString,
  version: _primitives.NonEmptyString,
  integration: _primitives.NonEmptyString.optional()
});
const RelatedIntegrationArray = exports.RelatedIntegrationArray = _zod.z.array(RelatedIntegration);

/**
  * Schema for fields relating to investigation fields. These are user defined fields we use to highlight
in various features in the UI such as alert details flyout and exceptions auto-population from alert.

  */

const InvestigationFields = exports.InvestigationFields = _zod.z.object({
  field_names: _zod.z.array(_primitives.NonEmptyString).min(1)
});

/**
 * Defines how often rule actions are taken.
 */

const RuleActionThrottle = exports.RuleActionThrottle = _zod.z.union([_zod.z.enum(['no_actions', 'rule']), _zod.z.string().regex(/^[1-9]\d*[smhd]$/)]);

/**
 * Defines how often rules run actions.
 */

const RuleActionNotifyWhen = exports.RuleActionNotifyWhen = _zod.z.enum(['onActiveAlert', 'onThrottleInterval', 'onActionGroupChange']);
const RuleActionNotifyWhenEnum = exports.RuleActionNotifyWhenEnum = RuleActionNotifyWhen.enum;

/**
 * The action frequency defines when the action runs (for example, only on rule execution or at specific time intervals).
 */

const RuleActionFrequency = exports.RuleActionFrequency = _zod.z.object({
  /**
   * Action summary indicates whether we will send a summary notification about all the generate alerts or notification per individual alert
   */
  summary: _zod.z.boolean(),
  notifyWhen: RuleActionNotifyWhen,
  throttle: RuleActionThrottle.nullable()
});

/**
  * Object containing an action’s conditional filters.

- `timeframe` (object, optional): Object containing the time frame for when this action can be run.
    - `days` (array of integers, required): List of days of the week on which this action will be run. Days of the week are expressed as numbers between `1-7`, where `1` is Monday and `7` is Sunday. To select all days of the week, enter an empty array.
    - `hours` (object, required): The hours of the day during which this action will run. Hours of the day are expressed as two strings in the format `hh:mm` in `24` hour time. A start of `00:00` and an end of `24:00` means the action can run all day.
        - start (string, required): Start time in `hh:mm` format.
        - end (string, required): End time in `hh:mm` format.
    - `timezone` (string, required): An ISO timezone name, such as `Europe/Madrid` or `America/New_York`. Specific offsets such as `UTC` or `UTC+1` will also work, but lack built-in DST.
- `query` (object, optional): Object containing a query filter which gets applied to an action and determines whether the action should run.
    - `kql` (string, required): A KQL string.
    - `filters` (array of objects, required): Array of filter objects, as defined in the `kbn-es-query` package.

  */

const RuleActionAlertsFilter = exports.RuleActionAlertsFilter = _zod.z.object({}).catchall(_zod.z.unknown());

/**
  * Object containing the allowed connector fields, which varies according to the connector type.

For Slack:

  - `message` (string, required): The notification message.

For email:

  - `to`, `cc`, `bcc` (string): Email addresses to which the notifications are sent. At least one field must have a value.
  - `subject` (string, optional): Email subject line.
  - `message` (string, required): Email body text.

For Webhook:

  - `body` (string, required): JSON payload.

For PagerDuty:

  - `severity` (string, required): Severity of on the alert notification, can be: `Critical`, `Error`, `Warning` or `Info`.
  - `eventAction` (string, required): Event [action type](https://v2.developer.pagerduty.com/docs/events-api-v2#event-action), which can be `trigger`, `resolve`, or `acknowledge`.
  - `dedupKey` (string, optional): Groups alert notifications with the same PagerDuty alert.
  - `timestamp` (DateTime, optional): ISO-8601 format [timestamp](https://v2.developer.pagerduty.com/docs/types#datetime).
  - `component` (string, optional): Source machine component responsible for the event, for example `security-solution`.
  - `group` (string, optional): Enables logical grouping of service components.
  - `source` (string, optional): The affected system. Defaults to the Kibana saved object ID of the action.
  - `summary` (string, options): Summary of the event. Defaults to `No summary provided`. Maximum length is 1024 characters.
  - `class` (string, optional): Value indicating the class/type of the event.

  */

const RuleActionParams = exports.RuleActionParams = _zod.z.object({}).catchall(_zod.z.unknown());

/**
 * Optionally groups actions by use cases. Use `default` for alert notifications.
 */

const RuleActionGroup = exports.RuleActionGroup = _zod.z.string();

/**
 * The connector ID.
 */

const RuleActionId = exports.RuleActionId = _zod.z.string();
const RuleAction = exports.RuleAction = _zod.z.object({
  /** 
      * The action type used for sending notifications, can be:
   - `.slack`
  - `.slack_api`
  - `.email`
  - `.index`
  - `.pagerduty`
  - `.swimlane`
  - `.webhook`
  - `.servicenow`
  - `.servicenow-itom`
  - `.servicenow-sir`
  - `.jira`
  - `.resilient`
  - `.opsgenie`
  - `.teams`
  - `.torq`
  - `.tines`
  - `.d3security`
        */
  action_type_id: _zod.z.string(),
  group: RuleActionGroup.optional(),
  id: RuleActionId,
  params: RuleActionParams,
  uuid: _primitives.NonEmptyString.optional(),
  alerts_filter: RuleActionAlertsFilter.optional(),
  frequency: RuleActionFrequency.optional()
});

/**
 * The exception type
 */

const ExceptionListType = exports.ExceptionListType = _zod.z.enum(['detection', 'rule_default', 'endpoint', 'endpoint_trusted_apps', 'endpoint_trusted_devices', 'endpoint_events', 'endpoint_host_isolation_exceptions', 'endpoint_blocklists']);
const ExceptionListTypeEnum = exports.ExceptionListTypeEnum = ExceptionListType.enum;

/**
  * Array of [exception containers](https://www.elastic.co/guide/en/security/current/exceptions-api-overview.html), which define exceptions that prevent the rule from generating alerts even when its other criteria are met.

  */

const RuleExceptionList = exports.RuleExceptionList = _zod.z.object({
  /**
   * ID of the exception container
   */
  id: _zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString),
  /**
   * List ID of the exception container
   */
  list_id: _zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString),
  type: ExceptionListType,
  /**
   * Determines the exceptions validity in rule's Kibana space
   */
  namespace_type: _zod.z.enum(['agnostic', 'single'])
});

/**
 * Time unit
 */

const AlertSuppressionDurationUnit = exports.AlertSuppressionDurationUnit = _zod.z.enum(['s', 'm', 'h']);
const AlertSuppressionDurationUnitEnum = exports.AlertSuppressionDurationUnitEnum = AlertSuppressionDurationUnit.enum;
const AlertSuppressionDuration = exports.AlertSuppressionDuration = _zod.z.object({
  value: _zod.z.number().int().min(1),
  unit: AlertSuppressionDurationUnit
});

/**
  * Describes how alerts will be generated for documents with missing suppress by fields:
doNotSuppress - per each document a separate alert will be created
suppress - only alert will be created per suppress by bucket
  */

const AlertSuppressionMissingFieldsStrategy = exports.AlertSuppressionMissingFieldsStrategy = _zod.z.enum(['doNotSuppress', 'suppress']);
const AlertSuppressionMissingFieldsStrategyEnum = exports.AlertSuppressionMissingFieldsStrategyEnum = AlertSuppressionMissingFieldsStrategy.enum;
const AlertSuppressionGroupBy = exports.AlertSuppressionGroupBy = _zod.z.array(_zod.z.string()).min(1).max(3);

/**
 * Defines alert suppression configuration.
 */

const AlertSuppression = exports.AlertSuppression = _zod.z.object({
  group_by: AlertSuppressionGroupBy,
  duration: AlertSuppressionDuration.optional(),
  missing_fields_strategy: AlertSuppressionMissingFieldsStrategy.optional()
});
const AlertSuppressionCamel = exports.AlertSuppressionCamel = _zod.z.object({
  groupBy: AlertSuppressionGroupBy,
  duration: AlertSuppressionDuration.optional(),
  missingFieldsStrategy: AlertSuppressionMissingFieldsStrategy.optional()
});
const GapFillStatus = exports.GapFillStatus = _zod.z.enum(['unfilled', 'in_progress', 'filled']);
const GapFillStatusEnum = exports.GapFillStatusEnum = GapFillStatus.enum;