"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createExploreNavigationTree = void 0;
var _constants = require("../constants");
var _link_groups = require("../link_groups");
var _links = require("../links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createExploreNavigationTree = () => ({
  id: _constants.SecurityGroupName.explore,
  title: _link_groups.SecurityLinkGroup[_constants.SecurityGroupName.explore].title,
  renderAs: 'panelOpener',
  icon: 'globe',
  children: [{
    id: _constants.SecurityPageName.hosts,
    link: (0, _links.securityLink)(_constants.SecurityPageName.hosts),
    children: [{
      id: _constants.SecurityPageName.hostsAll,
      link: (0, _links.securityLink)(_constants.SecurityPageName.hostsAll),
      breadcrumbStatus: 'hidden'
    }, {
      id: _constants.SecurityPageName.hostsUncommonProcesses,
      link: (0, _links.securityLink)(_constants.SecurityPageName.hostsUncommonProcesses),
      breadcrumbStatus: 'hidden'
    }, {
      id: _constants.SecurityPageName.hostsAnomalies,
      link: (0, _links.securityLink)(_constants.SecurityPageName.hostsAnomalies),
      breadcrumbStatus: 'hidden'
    }, {
      id: _constants.SecurityPageName.hostsEvents,
      link: (0, _links.securityLink)(_constants.SecurityPageName.hostsEvents),
      breadcrumbStatus: 'hidden'
    }, {
      id: _constants.SecurityPageName.hostsRisk,
      link: (0, _links.securityLink)(_constants.SecurityPageName.hostsRisk),
      breadcrumbStatus: 'hidden'
    }, {
      id: _constants.SecurityPageName.hostsSessions,
      link: (0, _links.securityLink)(_constants.SecurityPageName.hostsSessions),
      breadcrumbStatus: 'hidden'
    }]
  }, {
    id: _constants.SecurityPageName.network,
    link: (0, _links.securityLink)(_constants.SecurityPageName.network),
    children: [{
      id: _constants.SecurityPageName.networkFlows,
      link: (0, _links.securityLink)(_constants.SecurityPageName.networkFlows),
      breadcrumbStatus: 'hidden'
    }, {
      id: _constants.SecurityPageName.networkDns,
      link: (0, _links.securityLink)(_constants.SecurityPageName.networkDns),
      breadcrumbStatus: 'hidden'
    }, {
      id: _constants.SecurityPageName.networkHttp,
      link: (0, _links.securityLink)(_constants.SecurityPageName.networkHttp),
      breadcrumbStatus: 'hidden'
    }, {
      id: _constants.SecurityPageName.networkTls,
      link: (0, _links.securityLink)(_constants.SecurityPageName.networkTls),
      breadcrumbStatus: 'hidden'
    }, {
      id: _constants.SecurityPageName.networkAnomalies,
      link: (0, _links.securityLink)(_constants.SecurityPageName.networkAnomalies),
      breadcrumbStatus: 'hidden'
    }, {
      id: _constants.SecurityPageName.networkEvents,
      link: (0, _links.securityLink)(_constants.SecurityPageName.networkEvents),
      breadcrumbStatus: 'hidden'
    }]
  }, {
    id: _constants.SecurityPageName.users,
    link: (0, _links.securityLink)(_constants.SecurityPageName.users),
    children: [{
      id: _constants.SecurityPageName.usersAll,
      link: (0, _links.securityLink)(_constants.SecurityPageName.usersAll),
      breadcrumbStatus: 'hidden'
    }, {
      id: _constants.SecurityPageName.usersAuthentications,
      link: (0, _links.securityLink)(_constants.SecurityPageName.usersAuthentications),
      breadcrumbStatus: 'hidden'
    }, {
      id: _constants.SecurityPageName.usersAnomalies,
      link: (0, _links.securityLink)(_constants.SecurityPageName.usersAnomalies),
      breadcrumbStatus: 'hidden'
    }, {
      id: _constants.SecurityPageName.usersRisk,
      link: (0, _links.securityLink)(_constants.SecurityPageName.usersRisk),
      breadcrumbStatus: 'hidden'
    }, {
      id: _constants.SecurityPageName.usersEvents,
      link: (0, _links.securityLink)(_constants.SecurityPageName.usersEvents),
      breadcrumbStatus: 'hidden'
    }]
  }]
});
exports.createExploreNavigationTree = createExploreNavigationTree;