"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEntityAnalyticsNavigationTree = void 0;
var _react = require("react");
var _constants = require("../constants");
var _link_groups = require("../link_groups");
var _links = require("../links");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LazyIconEntityAnalytics = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./custom_icons/entity_analytics'))).then(({
  iconEntityAnalytics
}) => ({
  default: iconEntityAnalytics
})));
const createEntityAnalyticsNavigationTree = () => ({
  id: _constants.SecurityGroupName.entityAnalytics,
  icon: LazyIconEntityAnalytics,
  title: _link_groups.SecurityLinkGroup[_constants.SecurityGroupName.entityAnalytics].title,
  renderAs: 'panelOpener',
  children: [{
    id: _constants.SecurityPageName.entityAnalyticsOverview,
    link: (0, _links.securityLink)(_constants.SecurityPageName.entityAnalyticsOverview)
  }, {
    id: _constants.SecurityPageName.entityAnalyticsPrivilegedUserMonitoring,
    link: (0, _links.securityLink)(_constants.SecurityPageName.entityAnalyticsPrivilegedUserMonitoring)
  }, {
    id: _constants.SecurityPageName.entityAnalyticsThreatHunting,
    link: (0, _links.securityLink)(_constants.SecurityPageName.entityAnalyticsThreatHunting)
  }]
});
exports.createEntityAnalyticsNavigationTree = createEntityAnalyticsNavigationTree;