"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecurityV3BaseKibanaFeature = void 0;
var _i18n = require("@kbn/i18n");
var _coreApplicationCommon = require("@kbn/core-application-common");
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SECURITY_RULE_TYPES = [_constants.LEGACY_NOTIFICATIONS_ID, _securitysolutionRules.ESQL_RULE_TYPE_ID, _securitysolutionRules.EQL_RULE_TYPE_ID, _securitysolutionRules.INDICATOR_RULE_TYPE_ID, _securitysolutionRules.ML_RULE_TYPE_ID, _securitysolutionRules.QUERY_RULE_TYPE_ID, _securitysolutionRules.SAVED_QUERY_RULE_TYPE_ID, _securitysolutionRules.THRESHOLD_RULE_TYPE_ID, _securitysolutionRules.NEW_TERMS_RULE_TYPE_ID];
const alertingFeatures = SECURITY_RULE_TYPES.map(ruleTypeId => ({
  ruleTypeId,
  consumers: [_constants.SERVER_APP_ID]
}));
const getSecurityV3BaseKibanaFeature = ({
  savedObjects
}) => ({
  deprecated: {
    notice: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.linkSecuritySolutionSecurity.deprecationMessage', {
      defaultMessage: 'The {currentId} permissions are deprecated, please see {latestId}.',
      values: {
        currentId: _constants.SECURITY_FEATURE_ID_V3,
        latestId: _constants.SECURITY_FEATURE_ID_V5
      }
    })
  },
  id: _constants.SECURITY_FEATURE_ID_V3,
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.linkSecuritySolutionTitle', {
    defaultMessage: 'Security'
  }),
  order: 1100,
  category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security,
  app: [_constants.APP_ID, _constants.CLOUD_POSTURE_APP_ID, 'kibana'],
  catalogue: [_constants.APP_ID],
  management: {
    insightsAndAlerting: ['triggersActions']
  },
  alerting: alertingFeatures,
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.securityGroupDescription', {
    defaultMessage: "Each sub-feature privilege in this group must be assigned individually. Global assignment is only supported if your pricing plan doesn't allow individual feature privileges."
  }),
  privileges: {
    all: {
      replacedBy: {
        default: [{
          feature: _constants.SECURITY_FEATURE_ID_V5,
          privileges: ['all']
        }, {
          feature: _constants.RULES_FEATURE_ID,
          privileges: ['all']
        }],
        minimal: [{
          feature: _constants.SECURITY_FEATURE_ID_V5,
          privileges: ['minimal_all']
        }, {
          feature: _constants.RULES_FEATURE_ID,
          privileges: ['minimal_all']
        }]
      },
      app: [_constants.APP_ID, _constants.CLOUD_POSTURE_APP_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      api: [_constants.APP_ID, 'rac', _constants.LISTS_API_ALL, _constants.LISTS_API_READ, _constants.LISTS_API_SUMMARY, _constants.RULES_API_ALL, _constants.RULES_API_READ, _constants.ALERTS_API_ALL, _constants.ALERTS_API_READ, _constants.EXCEPTIONS_API_ALL, _constants.EXCEPTIONS_API_READ, _constants.USERS_API_READ, _constants.INITIALIZE_SECURITY_SOLUTION],
      savedObject: {
        all: ['alert', ...savedObjects],
        read: []
      },
      alerting: {
        rule: {
          all: alertingFeatures
        },
        alert: {
          all: alertingFeatures
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: [_constants.SECURITY_UI_SHOW, _constants.SECURITY_UI_CRUD]
    },
    read: {
      replacedBy: {
        default: [{
          feature: _constants.SECURITY_FEATURE_ID_V5,
          privileges: ['read']
        }, {
          feature: _constants.RULES_FEATURE_ID,
          privileges: ['read']
        }],
        minimal: [{
          feature: _constants.SECURITY_FEATURE_ID_V5,
          privileges: ['minimal_read']
        }, {
          feature: _constants.RULES_FEATURE_ID,
          privileges: ['minimal_read']
        }]
      },
      app: [_constants.APP_ID, _constants.CLOUD_POSTURE_APP_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      api: [_constants.APP_ID, 'rac', _constants.LISTS_API_READ, _constants.RULES_API_READ, _constants.ALERTS_API_READ, _constants.EXCEPTIONS_API_READ, _constants.USERS_API_READ, _constants.INITIALIZE_SECURITY_SOLUTION],
      savedObject: {
        all: [],
        read: [...savedObjects]
      },
      alerting: {
        rule: {
          read: alertingFeatures
        },
        alert: {
          all: alertingFeatures
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: [_constants.SECURITY_UI_SHOW]
    }
  }
});
exports.getSecurityV3BaseKibanaFeature = getSecurityV3BaseKibanaFeature;