"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.securityV2ProductFeaturesConfig = void 0;
var _product_features_keys = require("../../product_features_keys");
var _constants = require("../../constants");
var _utils = require("../../utils");
var _product_feature_config = require("../product_feature_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const securityV2ProductFeaturesConfig = exports.securityV2ProductFeaturesConfig = (0, _utils.extendProductFeatureConfigs)(_product_feature_config.securityDefaultProductFeaturesConfig, {
  // Add the global artifact management API privilege to the all privileges of siem and siemV2 features for backwards compatibility
  // The siemV3 adds the global artifact management API privilege as a sub-feature.
  // This config adds the new global artifact management API privilege to old versions so we have only one way of authorizing this functionality.
  // No need to add the ui capability here, since they are automatically added by the Kibana features framework via the `replacedBy` field.
  [_product_features_keys.ProductFeatureSecurityKey.endpointArtifactManagement]: {
    // Adds the action to the top-level feature "all" privilege
    privileges: {
      all: {
        api: [`${_constants.APP_ID}-writeGlobalArtifacts`]
      }
    },
    // Some sub-features were also allowing this action, they need to be extended as well (the top-level feature may be in "read" level).
    subFeaturesPrivileges: [{
      id: 'endpoint_exceptions_all',
      api: [`${_constants.APP_ID}-writeGlobalArtifacts`]
    }, {
      id: 'trusted_applications_all',
      api: [`${_constants.APP_ID}-writeGlobalArtifacts`]
    }, {
      id: 'host_isolation_exceptions_all',
      api: [`${_constants.APP_ID}-writeGlobalArtifacts`]
    }, {
      id: 'blocklist_all',
      api: [`${_constants.APP_ID}-writeGlobalArtifacts`]
    }, {
      id: 'event_filters_all',
      api: [`${_constants.APP_ID}-writeGlobalArtifacts`]
    }]
  }
});