"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSolutionNavigation = void 0;
var _rxjs = _interopRequireWildcard(require("rxjs"));
var Rx = _rxjs;
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _aiAssistantCommon = require("@kbn/ai-assistant-common");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _links = require("@kbn/security-solution-navigation/links");
var _translations = require("./translations");
var _navigation_tree = require("./navigation_tree");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSolutionNavigation = async services => {
  const {
    securitySolution,
    navigation
  } = services;
  const chatExperience$ = services.settings.client.get$(_managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE, _aiAssistantCommon.AIChatExperience.Classic);

  // Get initial chat experience for setting initial navigation tree
  const initialChatExperience = await (0, _rxjs.firstValueFrom)(chatExperience$);
  const navigationTree = (0, _navigation_tree.createNavigationTree)(services, initialChatExperience);
  navigation.isSolutionNavEnabled$.subscribe(isSolutionNavigationEnabled => {
    if (isSolutionNavigationEnabled) {
      securitySolution.setSolutionNavigationTree(navigationTree);
    } else {
      securitySolution.setSolutionNavigationTree(null);
    }
  });
  navigation.addSolutionNavigation({
    id: 'security',
    title: _translations.SOLUTION_NAME,
    icon: 'logoSecurity',
    homePage: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.landing),
    navigationTree$: Rx.of(navigationTree),
    dataTestSubj: 'securitySolutionSideNav'
  });
};
exports.registerSolutionNavigation = registerSolutionNavigation;