"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityAction = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * The SecurityAction enumeration contains values for all valid shared object
 * security actions. The string for each value correlates to the ES operation.
 */
let SecurityAction = exports.SecurityAction = /*#__PURE__*/function (SecurityAction) {
  SecurityAction[SecurityAction["CHECK_CONFLICTS"] = 0] = "CHECK_CONFLICTS";
  SecurityAction[SecurityAction["CLOSE_POINT_IN_TIME"] = 1] = "CLOSE_POINT_IN_TIME";
  SecurityAction[SecurityAction["COLLECT_MULTINAMESPACE_REFERENCES"] = 2] = "COLLECT_MULTINAMESPACE_REFERENCES";
  SecurityAction[SecurityAction["COLLECT_MULTINAMESPACE_REFERENCES_UPDATE_SPACES"] = 3] = "COLLECT_MULTINAMESPACE_REFERENCES_UPDATE_SPACES";
  SecurityAction[SecurityAction["CREATE"] = 4] = "CREATE";
  SecurityAction[SecurityAction["BULK_CREATE"] = 5] = "BULK_CREATE";
  SecurityAction[SecurityAction["DELETE"] = 6] = "DELETE";
  SecurityAction[SecurityAction["BULK_DELETE"] = 7] = "BULK_DELETE";
  SecurityAction[SecurityAction["FIND"] = 8] = "FIND";
  SecurityAction[SecurityAction["GET"] = 9] = "GET";
  SecurityAction[SecurityAction["BULK_GET"] = 10] = "BULK_GET";
  SecurityAction[SecurityAction["INTERNAL_BULK_RESOLVE"] = 11] = "INTERNAL_BULK_RESOLVE";
  SecurityAction[SecurityAction["OPEN_POINT_IN_TIME"] = 12] = "OPEN_POINT_IN_TIME";
  SecurityAction[SecurityAction["REMOVE_REFERENCES"] = 13] = "REMOVE_REFERENCES";
  SecurityAction[SecurityAction["UPDATE"] = 14] = "UPDATE";
  SecurityAction[SecurityAction["BULK_UPDATE"] = 15] = "BULK_UPDATE";
  SecurityAction[SecurityAction["UPDATE_OBJECTS_SPACES"] = 16] = "UPDATE_OBJECTS_SPACES";
  SecurityAction[SecurityAction["CHANGE_OWNERSHIP"] = 17] = "CHANGE_OWNERSHIP";
  SecurityAction[SecurityAction["CHANGE_ACCESS_MODE"] = 18] = "CHANGE_ACCESS_MODE";
  return SecurityAction;
}({});