"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RolesGridPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _confirm_delete = require("./confirm_delete");
var _permission_denied = require("./permission_denied");
var _model = require("../../../../common/model");
var _badges = require("../../badges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/roles/roles_grid/roles_grid_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getRoleManagementHref = (action, roleName) => {
  return `/${action}${roleName ? `/${encodeURIComponent(roleName)}` : ''}`;
};
const MAX_PAGINATED_ITEMS = 10000;
const DEFAULT_TABLE_STATE = {
  query: _eui.EuiSearchBar.Query.MATCH_ALL,
  sort: {
    field: 'name',
    direction: 'asc'
  },
  from: 0,
  size: 25,
  filters: {
    showReservedRoles: true
  }
};
const RolesGridPage = ({
  notifications,
  rolesAPIClient,
  history,
  readOnly,
  buildFlavor,
  cloudOrgUrl,
  ...startServices
}) => {
  var _rolesResponse$roles, _rolesResponse$total;
  const [rolesResponse, setRolesResponse] = (0, _react.useState)({});
  const [selection, setSelection] = (0, _react.useState)([]);
  const [showDeleteConfirmation, setShowDeleteConfirmation] = (0, _react.useState)(false);
  const [permissionDenied, setPermissionDenied] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [tableState, setTableState] = (0, _react.useState)(DEFAULT_TABLE_STATE);
  const loadRoles = async tableStateArgs => {
    const queryText = tableStateArgs.query.text;
    const requestBody = {
      ...tableStateArgs,
      ...(tableStateArgs.sort ? {
        sort: tableStateArgs.sort
      } : DEFAULT_TABLE_STATE.sort),
      query: queryText
    };
    try {
      setIsLoading(true);
      const rolesFromApi = await rolesAPIClient.queryRoles(requestBody);
      setRolesResponse(rolesFromApi);
    } catch (e) {
      if (_lodash.default.get(e, 'body.statusCode') === 403) {
        setPermissionDenied(true);
      } else {
        notifications.toasts.addDanger(_i18n.i18n.translate('xpack.security.management.roles.fetchingRolesErrorMessage', {
          defaultMessage: 'Error fetching roles: {message}',
          values: {
            message: _lodash.default.get(e, 'body.message', '')
          }
        }));
      }
    } finally {
      setIsLoading(false);
    }
  };
  (0, _react.useEffect)(() => {
    loadRoles(DEFAULT_TABLE_STATE);
  }, []); // eslint-disable-line react-hooks/exhaustive-deps

  const onIncludeReservedRolesChange = e => {
    const newTableStateArgs = {
      ...tableState,
      filters: {
        showReservedRoles: e.target.checked
      }
    };
    setTableState(newTableStateArgs);
    loadRoles(newTableStateArgs);
  };
  const getRoleStatusBadges = role => {
    const enabled = (0, _model.isRoleEnabled)(role);
    const deprecated = (0, _model.isRoleDeprecated)(role);
    const reserved = (0, _model.isRoleReserved)(role);
    const badges = [];
    if (!enabled) {
      badges.push(/*#__PURE__*/_react.default.createElement(_badges.DisabledBadge, {
        "data-test-subj": "roleDisabled",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 19
        }
      }));
    }
    if (reserved) {
      badges.push(/*#__PURE__*/_react.default.createElement(_badges.ReservedBadge, {
        "data-test-subj": "roleReserved",
        tooltipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.roles.reservedRoleBadgeTooltip",
          defaultMessage: "Reserved roles are built-in and cannot be edited or removed.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 170,
            columnNumber: 13
          }
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 9
        }
      }));
    }
    if (deprecated) {
      badges.push(/*#__PURE__*/_react.default.createElement(_badges.DeprecatedBadge, {
        "data-test-subj": "roleDeprecated",
        tooltipContent: (0, _model.getExtendedRoleDeprecationNotice)(role),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 9
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 7
      }
    }, badges.map((badge, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index,
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 11
      }
    }, badge)));
  };
  const handleDelete = () => {
    setSelection([]);
    setShowDeleteConfirmation(false);
    loadRoles(tableState);
  };
  const deleteOneRole = roleToDelete => {
    setSelection([roleToDelete]);
    setShowDeleteConfirmation(true);
  };
  const renderToolsLeft = () => {
    if (selection.length === 0) {
      return;
    }
    const numSelected = selection.length;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "deleteRoleButton",
      color: "danger",
      onClick: () => setShowDeleteConfirmation(true),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.deleteSelectedRolesButtonLabel",
      defaultMessage: "Delete {numSelected} role{numSelected, plural, one { } other {s}}",
      values: {
        numSelected
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 9
      }
    }));
  };
  const renderToolsRight = () => {
    if (buildFlavor !== 'serverless') {
      var _tableState$filters$s;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        "data-test-subj": "showReservedRolesSwitch",
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.roles.showReservedRolesLabel",
          defaultMessage: "Show reserved roles",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 237,
            columnNumber: 13
          }
        }),
        checked: (_tableState$filters$s = tableState.filters.showReservedRoles) !== null && _tableState$filters$s !== void 0 ? _tableState$filters$s : true,
        onChange: onIncludeReservedRolesChange,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 234,
          columnNumber: 9
        }
      });
    }
  };
  const onTableChange = ({
    page,
    sort
  }) => {
    const newState = {
      ...tableState,
      from: (page === null || page === void 0 ? void 0 : page.index) * (page === null || page === void 0 ? void 0 : page.size),
      size: page === null || page === void 0 ? void 0 : page.size,
      sort: sort !== null && sort !== void 0 ? sort : tableState.sort
    };
    setTableState(newState);
    loadRoles(newState);
  };
  const onSearchChange = args => {
    if (!args.error && args.query) {
      const newState = {
        ...tableState,
        query: args.query
      };
      setTableState(newState);
      loadRoles(newState);
    }
  };
  const getColumnConfig = () => {
    const config = [{
      field: 'name',
      name: _i18n.i18n.translate('xpack.security.management.roles.nameColumnName', {
        defaultMessage: 'Role'
      }),
      sortable: true,
      render: name => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 280,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
        "data-test-subj": "roleRowName"
      }, (0, _public.reactRouterNavigate)(history, getRoleManagementHref('edit', name)), {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 281,
          columnNumber: 13
        }
      }), name))
    }, {
      field: 'description',
      name: _i18n.i18n.translate('xpack.security.management.roles.descriptionColumnName', {
        defaultMessage: 'Role Description'
      }),
      sortable: false,
      truncateText: {
        lines: 3
      },
      render: (description, record) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: description,
        display: "block",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 298,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        size: "s",
        "data-test-subj": `roleRowDescription-${record.name}`,
        tabIndex: 0,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 299,
          columnNumber: 13
        }
      }, description))
    }];
    if (buildFlavor !== 'serverless') {
      config.push({
        field: 'metadata',
        name: _i18n.i18n.translate('xpack.security.management.roles.statusColumnName', {
          defaultMessage: 'Status'
        }),
        sortable: false,
        render: (_metadata, record) => getRoleStatusBadges(record)
      });
    }
    if (!readOnly) {
      config.push({
        name: _i18n.i18n.translate('xpack.security.management.roles.actionsColumnName', {
          defaultMessage: 'Actions'
        }),
        width: '150px',
        actions: [{
          type: 'icon',
          icon: 'copy',
          isPrimary: true,
          available: role => !(0, _model.isRoleReserved)(role),
          name: _i18n.i18n.translate('xpack.security.management.roles.cloneRoleActionName', {
            defaultMessage: 'Clone'
          }),
          description: role => _i18n.i18n.translate('xpack.security.management.roles.cloneRoleActionLabel', {
            defaultMessage: 'Clone {roleName}',
            values: {
              roleName: role.name
            }
          }),
          href: role => (0, _public.reactRouterNavigate)(history, getRoleManagementHref('clone', role.name)).href,
          onClick: (role, event) => (0, _public.reactRouterNavigate)(history, getRoleManagementHref('clone', role.name)).onClick(event),
          'data-test-subj': role => `clone-role-action-${role.name}`
        }, {
          type: 'icon',
          icon: 'trash',
          color: 'danger',
          name: _i18n.i18n.translate('xpack.security.management.roles.deleteRoleActionName', {
            defaultMessage: 'Delete'
          }),
          description: role => _i18n.i18n.translate('xpack.security.management.roles.deleteRoleActionLabel', {
            defaultMessage: `Delete {roleName}`,
            values: {
              roleName: role.name
            }
          }),
          'data-test-subj': role => `delete-role-action-${role.name}`,
          onClick: role => deleteOneRole(role),
          available: role => !role.metadata || !role.metadata._reserved
        }, {
          isPrimary: true,
          type: 'icon',
          icon: 'pencil',
          name: _i18n.i18n.translate('xpack.security.management.roles.editRoleActionName', {
            defaultMessage: 'Edit'
          }),
          description: role => _i18n.i18n.translate('xpack.security.management.roles.editRoleActionLabel', {
            defaultMessage: `Edit {roleName}`,
            values: {
              roleName: role.name
            }
          }),
          'data-test-subj': role => `edit-role-action-${role.name}`,
          href: role => (0, _public.reactRouterNavigate)(history, getRoleManagementHref('edit', role.name)).href,
          onClick: (role, event) => (0, _public.reactRouterNavigate)(history, getRoleManagementHref('edit', role.name)).onClick(event),
          available: role => !(0, _model.isRoleReadOnly)(role),
          enabled: () => selection.length === 0
        }]
      });
    }
    return config;
  };
  const onCancelDelete = () => {
    setShowDeleteConfirmation(false);
  };
  const tableItems = (_rolesResponse$roles = rolesResponse.roles) !== null && _rolesResponse$roles !== void 0 ? _rolesResponse$roles : [];
  const totalItemCount = (_rolesResponse$total = rolesResponse.total) !== null && _rolesResponse$total !== void 0 ? _rolesResponse$total : 0;
  const displayedItemCount = Math.min(totalItemCount, MAX_PAGINATED_ITEMS);
  const pagination = {
    pageIndex: tableState.from / tableState.size,
    pageSize: tableState.size,
    totalItemCount: displayedItemCount,
    pageSizeOptions: [25, 50, 100]
  };
  const exceededResultCount = totalItemCount > MAX_PAGINATED_ITEMS;
  return permissionDenied ? /*#__PURE__*/_react.default.createElement(_permission_denied.PermissionDenied, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 411,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    bottomBorder: true,
    "data-test-subj": "rolesGridPageHeader",
    pageTitle: buildFlavor === 'serverless' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.customRoleTitle",
      defaultMessage: "Custom Roles",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 419,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.roleTitle",
      defaultMessage: "Roles",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 424,
        columnNumber: 13
      }
    }),
    description: buildFlavor === 'serverless' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.customRolesSubtitle",
      defaultMessage: "In addition to the predefined roles on the system, you can create your own roles and provide your users with the exact set of privileges that they need.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 432,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.subtitle",
      defaultMessage: "Apply roles to groups of users and manage permissions across the stack.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 437,
        columnNumber: 13
      }
    }),
    rightSideItems: readOnly ? undefined : [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
      "data-test-subj": "createRoleButton"
    }, (0, _public.reactRouterNavigate)(history, getRoleManagementHref('edit')), {
      fill: true,
      iconType: "plusInCircleFilled",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 447,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.createRoleButtonLabel",
      defaultMessage: "Create role",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 453,
        columnNumber: 19
      }
    })), buildFlavor === 'serverless' && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      href: cloudOrgUrl,
      target: "_blank",
      iconSide: "right",
      iconType: "popout",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 459,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.assignRolesLinkLabel",
      defaultMessage: "Assign roles",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 465,
        columnNumber: 21
      }
    }))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 414,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 475,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 476,
      columnNumber: 7
    }
  }, showDeleteConfirmation ? /*#__PURE__*/_react.default.createElement(_confirm_delete.ConfirmDelete, (0, _extends2.default)({
    onCancel: onCancelDelete,
    rolesToDelete: selection.map(role => role.name),
    callback: handleDelete,
    cloudOrgUrl: cloudOrgUrl,
    notifications: notifications,
    rolesAPIClient: rolesAPIClient,
    buildFlavor: buildFlavor
  }, startServices, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 478,
      columnNumber: 11
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    box: {
      incremental: true,
      'data-test-subj': 'searchRoles'
    },
    onChange: onSearchChange,
    toolsLeft: renderToolsLeft(),
    toolsRight: renderToolsRight(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 490,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 499,
      columnNumber: 9
    }
  }), exceededResultCount && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    "data-test-subj": "rolesTableTooManyResultsLabel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 502,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.roles.table.tooManyResultsLabel",
    defaultMessage: "Showing {limit} of {totalItemCount, plural, one {# role} other {# roles}}",
    values: {
      totalItemCount,
      limit: MAX_PAGINATED_ITEMS
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 503,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 509,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": `${!isLoading ? 'rolesTable' : 'rolesTableLoading'}`,
    itemId: "name",
    columns: getColumnConfig(),
    tableCaption: _i18n.i18n.translate('xpack.security.management.roles.rolesTableCaption', {
      defaultMessage: 'List of roles'
    }),
    selection: readOnly ? undefined : {
      selectable: role => !role.metadata || !role.metadata._reserved,
      selectableMessage: selectable => !selectable ? 'Role is reserved' : '',
      onSelectionChange: value => setSelection(value),
      selected: selection
    },
    onChange: onTableChange,
    pagination: pagination,
    noItemsMessage: buildFlavor === 'serverless' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.noCustomRolesFound",
      defaultMessage: "No custom roles to show",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 534,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.noRolesFound",
      defaultMessage: "No items found",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 539,
        columnNumber: 15
      }
    }),
    items: tableItems,
    loading: isLoading,
    sorting: {
      sort: tableState.sort
    },
    rowProps: {
      'data-test-subj': 'roleRow'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 512,
      columnNumber: 9
    }
  })));
};
exports.RolesGridPage = RolesGridPage;