"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isQueryRuleFieldError = exports.isFieldError = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isFieldError = error => {
  return !!error && error.type !== undefined && error.message !== undefined;
};
exports.isFieldError = isFieldError;
const isQueryRuleFieldError = error => {
  return (error === null || error === void 0 ? void 0 : error.values) !== undefined && isFieldError(error.values) || (error === null || error === void 0 ? void 0 : error.metadata) !== undefined && isFieldError(error.metadata);
};
exports.isQueryRuleFieldError = isQueryRuleFieldError;