"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedPlaygroundHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _data_action_button = require("../data_action_button");
var _view_code_action = require("../view_code/view_code_action");
var _types = require("../../types");
var _use_search_playground_feature_flag = require("../../hooks/use_search_playground_feature_flag");
var _playground_more_options = require("./playground_more_options");
var _playground_name = require("./playground_name");
var _saved_button = require("./saved_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/saved_playground/saved_playground_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SavedPlaygroundHeader = ({
  pageMode,
  viewMode,
  onModeChange,
  isActionsDisabled = false,
  onSelectPageModeChange,
  playgroundName,
  hasChanges,
  onEditName,
  onDeletePlayground,
  onCopyPlayground
}) => {
  const isSearchModeEnabled = (0, _use_search_playground_feature_flag.useSearchPlaygroundFeatureFlag)();
  const options = [{
    id: _types.PlaygroundViewMode.preview,
    label: pageMode === _types.PlaygroundPageMode.chat ? _i18n.i18n.translate('xpack.searchPlayground.header.view.chat', {
      defaultMessage: 'Chat'
    }) : _i18n.i18n.translate('xpack.searchPlayground.header.view.preview', {
      defaultMessage: 'Preview'
    }),
    'data-test-subj': 'chatMode'
  }, {
    id: _types.PlaygroundViewMode.query,
    label: _i18n.i18n.translate('xpack.searchPlayground.header.view.query', {
      defaultMessage: 'Query'
    }),
    'data-test-subj': 'queryMode'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
    css: ({
      euiTheme
    }) => ({
      '.euiPageHeaderContent > .euiFlexGroup': {
        flexWrap: 'wrap'
      },
      backgroundColor: euiTheme.colors.emptyShade
    }),
    paddingSize: "s",
    "data-test-subj": "saved-playground-header",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_playground_name.PlaygroundName, {
    playgroundName: playgroundName,
    onEditName: onEditName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }), isSearchModeEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "page-mode-select",
    options: [{
      value: _types.PlaygroundPageMode.Chat,
      text: 'Chat'
    }, {
      value: _types.PlaygroundPageMode.Search,
      text: 'Search'
    }],
    value: pageMode,
    onChange: e => onSelectPageModeChange(e.target.value),
    "aria-label": _i18n.i18n.translate('xpack.searchPlayground.header.pageModeSelectAriaLabel', {
      defaultMessage: 'Page mode'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  }), hasChanges ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning",
    "data-test-subj": "playground-unsaved-changes-badge",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.header.unsavedChangesBadge",
    defaultMessage: "Unsaved changes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 15
    }
  })) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: "viewMode",
    options: options,
    idSelected: viewMode,
    onChange: id => onModeChange(id),
    buttonSize: "compressed",
    isDisabled: isActionsDisabled,
    "data-test-subj": "viewModeSelector",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, {
    css: ({
      euiTheme
    }) => ({
      paddingRight: euiTheme.size.s
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    "data-test-subj": "playground-header-actions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_data_action_button.DataActionButton, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    css: ({
      euiTheme
    }) => ({
      borderLeft: euiTheme.border.thin
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_view_code_action.ViewCodeAction, {
    selectedPageMode: pageMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_saved_button.SavedPlaygroundSaveButton, {
    hasChanges: hasChanges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_playground_more_options.PlaygroundMoreOptionsMenu, {
    onDeletePlayground: onDeletePlayground,
    onSavePlaygroundAs: onCopyPlayground,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  }))));
};
exports.SavedPlaygroundHeader = SavedPlaygroundHeader;