"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Chat = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _uuid = require("uuid");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../analytics/constants");
var _use_auto_bottom_scroll = require("../hooks/use_auto_bottom_scroll");
var _chat_sidebar = require("./chat_sidebar");
var _use_chat = require("../hooks/use_chat");
var _types = require("../types");
var _message_list = require("./message_list/message_list");
var _question_input = require("./question_input");
var _telegram_icon = require("./telegram_icon");
var _transform_to_messages = require("../utils/transform_to_messages");
var _use_usage_tracker = require("../hooks/use_usage_tracker");
var _playground_body_section = require("./playground_body_section");
var _user_query = require("../utils/user_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/chat.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const buildFormData = (formData, formErrors) => ({
  connector_id: formData[_types.PlaygroundFormFields.summarizationModel].connectorId,
  prompt: formData[_types.PlaygroundFormFields.prompt],
  indices: formData[_types.PlaygroundFormFields.indices].join(),
  citations: formData[_types.PlaygroundFormFields.citations],
  elasticsearch_query: (0, _user_query.elasticsearchQueryString)(formData[_types.PlaygroundFormFields.elasticsearchQuery], formData[_types.PlaygroundFormFields.userElasticsearchQuery], formErrors[_types.PlaygroundFormFields.userElasticsearchQuery]),
  summarization_model: formData[_types.PlaygroundFormFields.summarizationModel].value,
  source_fields: JSON.stringify(formData[_types.PlaygroundFormFields.sourceFields]),
  doc_size: formData[_types.PlaygroundFormFields.docSize]
});
const Chat = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    control,
    formState: {
      isValid,
      isSubmitting,
      errors: formErrors
    },
    resetField,
    handleSubmit,
    getValues
  } = (0, _reactHookForm.useFormContext)();
  const {
    messages,
    append,
    stop: stopRequest,
    setMessages,
    reload
  } = (0, _use_chat.useChat)();
  const messagesRef = (0, _use_auto_bottom_scroll.useAutoBottomScroll)();
  const [isRegenerating, setIsRegenerating] = (0, _react.useState)(false);
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const onSubmit = async data => {
    await append({
      content: data.question,
      role: _types.MessageRole.user,
      createdAt: new Date()
    }, {
      data: buildFormData(data, formErrors)
    });
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.chatQuestionSent);
    resetField(_types.PlaygroundFormFields.question);
  };
  const handleStopRequest = () => {
    stopRequest();
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.chatRequestStopped);
  };
  const chatMessages = (0, _react.useMemo)(() => [{
    id: (0, _uuid.v4)(),
    role: _types.MessageRole.system,
    content: 'Welcome! Ask a question to get started.'
  }, ...(0, _transform_to_messages.transformFromChatMessages)(messages)], [messages]);
  const isToolBarActionsDisabled = (0, _react.useMemo)(() => chatMessages.length <= 1 || isRegenerating || isSubmitting, [chatMessages, isSubmitting, isRegenerating]);
  const regenerateMessages = async () => {
    setIsRegenerating(true);
    const formData = getValues();
    await reload({
      data: buildFormData(formData, formErrors)
    });
    setIsRegenerating(false);
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.chatRegenerateMessages);
  };
  const handleClearChat = () => {
    setMessages([]);
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.chatCleared);
  };
  (0, _react.useEffect)(() => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.load(_constants.AnalyticsEvents.chatPageLoaded);
  }, [usageTracker]);
  return /*#__PURE__*/_react.default.createElement(_playground_body_section.PlaygroundBodySection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    css: {
      display: 'flex',
      flexGrow: 1
    },
    onSubmit: handleSubmit(onSubmit),
    "data-test-subj": "chatPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    css: {
      paddingTop: euiTheme.size.l,
      paddingBottom: euiTheme.size.l,
      // don't allow the chat to shrink below 700px
      flexBasis: 0,
      minWidth: 700
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    className: "eui-fullHeight",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    className: "eui-yScroll",
    css: {
      paddingLeft: euiTheme.size.l,
      paddingRight: euiTheme.size.l
    },
    tabIndex: 0,
    ref: messagesRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_message_list.MessageList, {
    messages: chatMessages,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      paddingLeft: euiTheme.size.l,
      paddingRight: euiTheme.size.l
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "sparkles",
    disabled: isToolBarActionsDisabled,
    onClick: regenerateMessages,
    size: "xs",
    "data-test-subj": "regenerateActionButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.chat.regenerateBtn",
    defaultMessage: "Regenerate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 23
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "refresh",
    disabled: isToolBarActionsDisabled,
    onClick: handleClearChat,
    size: "xs",
    "data-test-subj": "clearChatActionButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.chat.clearChatBtn",
    defaultMessage: "Clear chat",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 23
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: _types.PlaygroundFormFields.question,
    control: control,
    defaultValue: "",
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_question_input.QuestionInput, {
      value: field.value,
      onChange: field.onChange,
      isDisabled: isSubmitting || isRegenerating,
      button: isSubmitting || isRegenerating ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": "stopRequestButton",
        "aria-label": _i18n.i18n.translate('xpack.searchPlayground.chat.stopButtonAriaLabel', {
          defaultMessage: 'Stop request'
        }),
        display: "base",
        size: "s",
        iconType: "stop",
        onClick: handleStopRequest,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 208,
          columnNumber: 27
        }
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "aria-label": _i18n.i18n.translate('xpack.searchPlayground.chat.sendButtonAriaLabel', {
          defaultMessage: 'Send a question'
        }),
        display: isValid ? 'base' : 'empty',
        size: "s",
        type: "submit",
        isLoading: isSubmitting,
        isDisabled: !isValid,
        iconType: _telegram_icon.TelegramIcon,
        "data-test-subj": "sendQuestionButton",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 222,
          columnNumber: 27
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 21
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
    sizes: ['xs', 's'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    css: {
      flexBasis: 0,
      minWidth: '33.3%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_chat_sidebar.ChatSidebar, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 15
    }
  }))))));
};
exports.Chat = Chat;