/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.searchNotebooks_bundle_jsonpfunction=self.searchNotebooks_bundle_jsonpfunction||[]).push([[857],{857:(e,o,t)=>{t.r(o),t.d(o,{SearchNotebooksView:()=>q});var n=t(286),s=t.n(n),a=t(409),l=t(999),i=t(530),r=t(319),u=t(8);const c={id:"introduction",title:u.i18n.translate("xpack.searchNotebooks.introductionNotebook.title",{defaultMessage:"Jupyter notebooks"}),description:u.i18n.translate("xpack.searchNotebooks.introductionNotebook.description",{defaultMessage:"Learn all about Jupyter notebooks, how to preview them in the UI, and how to run them."}),notebook:{cells:[{cell_type:"markdown",source:["# What are Jupyter notebooks?\n","\n","Jupyter Notebooks combine executable code and rich Markdown documentation in a single interactive document. Easy to run, edit and share, they enable collaboration in fields like data science, scientific computing, and machine learning.","\n","\n","Notebooks are composed of cells, which can contain Markdown text like this, or Python code like the cell below.\n"]},{cell_type:"code",source:['print("Hello world!!!")\n']},{cell_type:"markdown",source:["\nNotebooks are a great way to test and prototype code, and share results with others. In our notebooks we use the official [Elasticsearch Python client](https://elasticsearch-py.readthedocs.io/en/latest/) to call the Elasticsearch APIs."]},{cell_type:"markdown",source:["## Elastic Jupyter notebooks\n","\n","You can **preview** a number of our Jupyter notebooks right here in the UI. Check out the next section for how to **run** notebooks.\n","\nFind all of our available notebooks in the `elasticsearch-labs` [GitHub repository](https://github.com/elastic/elasticsearch-labs).","\n","## How to run notebooks\n","\n","You can run notebooks in two ways:","\n","- **Run in Colab**: You can run all our notebooks in Google [Colab](https://colab.research.google.com), a free, zero configuration, in-browser notebook execution environment. Just click the `Open in Colab` button at the top of a notebook to test it in Colab.\n","- **Run locally**: You can also download the notebooks from the repository and run them locally using tools like [JupyterLab](https://jupyter.org/install).\n","\n","ℹ️ Just make sure to copy your **Elasticsearch endpoint and API key** so the notebook can run against your deployment.\n","\n","## Learn more\n","\n","Check out [Elastic Search Labs](https://www.elastic.co/search-labs) for all the latest advanced content for Elasticsearch users, including additional Python examples."]}]}},d="introduction",b=()=>(0,a.useKibana)().services;var x=t(151);var k=t(791);const p=()=>(0,k.jsx)(r.EuiPanel,{color:"subdued"},(0,k.jsx)(r.EuiLoadingSpinner,null)),h=({description:e,id:o,isSelected:t,title:n,onClick:a})=>{const{euiTheme:l}=(0,r.useEuiTheme)();return(0,k.jsx)(s().Fragment,null,(0,k.jsx)(r.EuiPanel,{"data-test-subj":`console-embedded-notebook-select-btn-${o}`,"data-telemdata-telemetry-id":`console-embedded-notebook-select-btn-${o}`,onClick:()=>a(o),color:t?"primary":"subdued",hasBorder:!0},(0,k.jsx)(r.EuiTitle,{size:"xxs"},(0,k.jsx)("h5",null,(0,k.jsx)(r.EuiTextColor,{color:l.colors.primaryText},n))),(0,k.jsx)(r.EuiSpacer,{size:"xs"}),(0,k.jsx)(r.EuiText,{size:"s",color:t?l.colors.primaryText:"subdued"},(0,k.jsx)("p",null,e))),(0,k.jsx)(r.EuiHorizontalRule,{margin:"none"}))},g=({notebooks:e,onNotebookSelect:o,selectedNotebookId:t})=>null===e?(0,k.jsx)(p,null):(0,k.jsx)(s().Fragment,null,e.map((e=>(0,k.jsx)(h,{key:e.id,id:e.id,title:e.title,description:e.description,onClick:o,isSelected:t===e.id})))),j=({children:e})=>(0,k.jsx)(s().Fragment,null,(0,k.jsx)(r.EuiPanel,{hasShadow:!1,paddingSize:"s"},(0,k.jsx)(r.EuiText,{size:"s",color:"subdued"},e)),(0,k.jsx)(r.EuiHorizontalRule,{margin:"none"}));function m(e){return null!=e}function y(e){return m(e)&&e.length>0}const f=(e,o="")=>Array.isArray(e)?e.join(o):e,E=({cell:e,language:o})=>{if(!e.cell_type)return null;const t=e.source?f(e.source):e.input?f(e.input):null;if(!t)return null;switch(e.cell_type){case"markdown":return(0,k.jsx)(r.EuiMarkdownFormat,null,t);case"code":return(0,k.jsx)(r.EuiCodeBlock,{language:o,lineNumbers:!0,isCopyable:!0},t);case"heading":return(0,k.jsx)(r.EuiTitle,null,(0,k.jsx)("h2",null,t))}return null},v=({output:e})=>m(e.text)&&e.text.length>0?(0,k.jsx)(r.EuiCodeBlock,null,f(e.text)):y(e.png)?(0,k.jsx)(N,{value:e.png}):y(e.jpeg)?(0,k.jsx)(C,{value:e.jpeg}):y(e.gif)?(0,k.jsx)(S,{value:e.gif}):m(e.data)?m(e.data["text/plain"])?(0,k.jsx)(r.EuiCodeBlock,null,f(e.data["text/plain"])):y(e.data["image/png"])?(0,k.jsx)(N,{value:e.data["image/png"]}):y(e.data["image/jpeg"])?(0,k.jsx)(C,{value:e.data["image/jpeg"]}):y(e.data["image/gif"])?(0,k.jsx)(S,{value:e.data["image/gif"]}):m(e.data["text/html"])?(0,k.jsx)(r.EuiCodeBlock,{lineNumbers:!0},f(e.data["text/html"])):m(e.data["application/javascript"])?(0,k.jsx)(r.EuiCodeBlock,{lineNumbers:!0},f(e.data["application/javascript"])):m(e.data["text/latex"])?(0,k.jsx)(r.EuiCodeBlock,{lineNumbers:!0},f(e.data["text/latex"])):null:null,w=({value:e,type:o})=>(0,k.jsx)("img",{src:`data:image/${o};base64,${e}`,alt:`output ${o} image`,style:{maxHeight:"400px",maxWidth:"400px"}}),N=({value:e})=>(0,k.jsx)(w,{value:e,type:"png"}),C=({value:e})=>(0,k.jsx)(w,{value:e,type:"jpeg"}),S=({value:e})=>(0,k.jsx)(w,{value:e,type:"gif"}),F=({notebook:e})=>{var o,t,n;const{euiTheme:s}=(0,r.useEuiTheme)(),a=null!==(o=null===(t=e.metadata)||void 0===t||null===(n=t.language_info)||void 0===n?void 0:n.name)&&void 0!==o?o:"python";return(0,k.jsx)(r.EuiFlexGroup,{direction:"column",gutterSize:"xl",style:{maxWidth:50*s.base+"px"},justifyContent:"center"},e.cells.map(((e,o)=>{var t;const n=null!==(t=e.id)&&void 0!==t?t:`nb.cell.${o}`;return e.outputs&&e.outputs.length>0?(0,k.jsx)(r.EuiFlexItem,{key:n},(0,k.jsx)(r.EuiFlexGroup,{direction:"column",gutterSize:"s"},(0,k.jsx)(r.EuiFlexItem,null,(0,k.jsx)(E,{cell:e,language:a})),e.outputs.map(((e,o)=>(0,k.jsx)(r.EuiFlexItem,{key:`${n}.output.${o}`},(0,k.jsx)(v,{output:e})))))):(0,k.jsx)(r.EuiFlexItem,{key:n},(0,k.jsx)(E,{cell:e,language:a}))})))};var z=t(879),I=t(993),T={name:"1flj9lk",styles:"text-align:left"};const M=({error:e,notebookId:o,usageTracker:t})=>(s().useEffect((()=>{t.count(["notebookViewError",`error-${o}`])}),[t,o]),(0,k.jsx)(r.EuiEmptyPrompt,{iconType:"warning",iconColor:"danger",title:(0,k.jsx)("h2",null,(0,k.jsx)(z.FormattedMessage,{id:"xpack.searchNotebooks.notebook.fetchError.title",defaultMessage:"Error loading notebook"})),titleSize:"l",body:(0,k.jsx)(s().Fragment,null,(0,k.jsx)("p",null,(0,k.jsx)(z.FormattedMessage,{id:"xpack.searchNotebooks.notebook.fetchError.body",defaultMessage:"We can't fetch the notebook from Kibana due to the following error:"})),void 0!==e&&"object"==typeof e?(0,k.jsx)(r.EuiCodeBlock,{css:T},JSON.stringify(e)):(0,k.jsx)("p",null,(0,I.u1)(e,u.i18n.translate("xpack.searchNotebooks.notebook.fetchError.unknownError",{defaultMessage:"Unknown error fetching notebook"}))))})),_=({notebookId:e})=>{const o=(()=>{const{usageTracker:e}=b();return e})(),{data:t,isLoading:s,error:a}=(e=>{const{http:o}=b();return(0,i.useQuery)({queryKey:["fetchSearchNotebook",e],queryFn:()=>o.get(`/internal/search_notebooks/notebooks/${e}`)})})(e);return(0,n.useEffect)((()=>{o.count(["view-notebook",`nb-${e}`])}),[o,e]),s?(0,k.jsx)(p,null):!t||a?(0,k.jsx)(M,{notebookId:e,usageTracker:o,error:a}):(0,k.jsx)(r.EuiPanel,{paddingSize:"xl",hasShadow:!1,style:{display:"flex",justifyContent:"center"},"data-test-subj":`console-embedded-notebook-view-panel-${e}`},(0,k.jsx)(F,{notebook:t.notebook}))},L=()=>(0,k.jsx)(r.EuiPanel,{hasShadow:!1},(0,k.jsx)(r.EuiFlexGroup,{justifyContent:"center"},(0,k.jsx)(r.EuiButton,{href:"https://github.com/elastic/elasticsearch-labs/tree/main/notebooks",target:"_blank",iconSide:"right",iconType:"popout","data-test-subj":"console-notebooks-search-labs-btn","data-telemetry-id":"console-notebooks-search-labs-btn"},u.i18n.translate("xpack.searchNotebooks.searchLabsLink",{defaultMessage:"Browse all our notebooks"}))));var P=t(102);const $="notebooksList",B="notebooksOutput",J={[$]:25,[B]:75},G=()=>{var e;const[o,t]=(0,n.useState)(J),[a,l]=(0,n.useState)(null!==(e=(0,P.$0)())&&void 0!==e?e:d),{data:p}=(()=>{const{http:e}=b(),o=(()=>{const{notebooks:{getNotebookList:e}}=b(),o=(0,n.useMemo)((()=>e()),[e]);return(0,n.useMemo)((()=>(()=>{const[,e]=(window.location.search||window.location.hash||"").split("?"),o=(0,x.parse)(e||"",{sort:!1});if(o&&o.nblist&&"string"==typeof o.nblist)return o.nblist})()),[])||o||void 0})();return(0,i.useQuery)({queryKey:[`fetchNotebooksCatalog-${null!=o?o:"default"}`],queryFn:()=>e.get("/internal/search_notebooks/notebooks",{query:{list:o}})})})(),m=(0,n.useCallback)((e=>{t((o=>({...o,...e})))}),[]);(0,n.useEffect)((()=>{p&&(void 0!==p.notebooks.find((e=>e.id===a))||l(d))}),[p,a]);const y=(0,n.useMemo)((()=>p?p.notebooks:null),[p]),f=(0,n.useCallback)((e=>{l(e)}),[]);return(0,k.jsx)(r.EuiResizableContainer,{style:{height:"100%",width:"100%"},onPanelWidthChange:m,"data-test-subj":"consoleEmbeddedNotebooksContainer"},((e,t)=>(0,k.jsx)(s().Fragment,null,(0,k.jsx)(e,{id:$,size:o[$],minSize:"10%",tabIndex:0,paddingSize:"none"},(0,k.jsx)(r.EuiFlexGroup,{direction:"column",gutterSize:"none"},(0,k.jsx)(j,null,u.i18n.translate("xpack.searchNotebooks.notebooksList.introduction.title",{defaultMessage:"Introduction"})),(0,k.jsx)(h,{id:c.id,title:c.title,description:c.description,onClick:f,isSelected:a===c.id}),(0,k.jsx)(j,null,u.i18n.translate("xpack.searchNotebooks.notebooksList.availableNotebooks.title",{defaultMessage:"Notebook previews"})),(0,k.jsx)(g,{notebooks:y,selectedNotebookId:a,onNotebookSelect:f}),(0,k.jsx)(L,null))),(0,k.jsx)(t,null),(0,k.jsx)(e,{id:B,size:o[B],minSize:"200px",tabIndex:0,paddingSize:"none"},(0,k.jsx)(r.EuiFlexGroup,{direction:"column",gutterSize:"none"},(0,k.jsx)(r.EuiFlexItem,{grow:!1},(0,k.jsx)(j,null,u.i18n.translate("xpack.searchNotebooks.notebooksList.activeNotebook.title",{defaultMessage:"Active notebook"}))),(0,k.jsx)(r.EuiFlexItem,null,(0,k.jsx)(_,{notebookId:a})))))))},q=({core:e,queryClient:o,usageTracker:t,getNotebookList:n})=>(s().useEffect((()=>{t.count("opened_notebooks_view")}),[t]),(0,k.jsx)(l.KibanaThemeProvider,{theme:e.theme},(0,k.jsx)(a.KibanaContextProvider,{services:{...e,notebooks:{getNotebookList:n},usageTracker:t}},(0,k.jsx)(i.QueryClientProvider,{client:o},(0,k.jsx)(G,null)))))}}]);