"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchNotebooksButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_notebooks/public/components/notebooks_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SearchNotebooksButton = ({
  activeView,
  onClick,
  clearNotebookList
}) => {
  _react.default.useEffect(() => {
    return () => {
      // When the Notebooks button is unmounted we want to clear
      // any page specific contextual notebook list that was set.
      clearNotebookList();
    };
  }, [clearNotebookList]);
  if (activeView) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      onClick: onClick,
      size: "s",
      iconType: "documentation",
      iconSide: "left",
      "data-test-subj": "consoleEmbeddedNotebooksButton",
      "data-telemetry-id": "console-embedded-notebooks-button",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.searchNotebooks.notebooksButton.title', {
      defaultMessage: 'Notebooks'
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    onClick: onClick,
    size: "s",
    iconType: "documentation",
    iconSide: "left",
    "data-test-subj": "consoleEmbeddedNotebooksButton",
    "data-telemetry-id": "console-embedded-notebooks-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.searchNotebooks.notebooksButton.title', {
    defaultMessage: 'Notebooks'
  }));
};
exports.SearchNotebooksButton = SearchNotebooksButton;