"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditInferenceFlyout = void 0;
var _inference_flyout_wrapper = require("@kbn/inference-endpoint-ui-common/src/components/inference_flyout_wrapper");
var _react = _interopRequireWildcard(require("react"));
var _objectUtils = require("@kbn/object-utils");
var _inferenceEndpointUiCommon = require("@kbn/inference-endpoint-ui-common");
var _use_kibana = require("../../hooks/use_kibana");
var _use_inference_endpoints = require("../../hooks/use_inference_endpoints");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_inference_endpoints/public/components/edit_inference_endpoints/edit_inference_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditInferenceFlyout = ({
  onFlyoutClose,
  selectedInferenceEndpoint
}) => {
  var _selectedInferenceEnd, _selectedInferenceEnd2, _selectedInferenceEnd3, _selectedInferenceEnd4;
  const {
    services: {
      http,
      notifications: {
        toasts
      },
      serverless
    }
  } = (0, _use_kibana.useKibana)();
  const {
    refetch
  } = (0, _use_inference_endpoints.useQueryInferenceEndpoints)();
  const onEditSuccess = (0, _react.useCallback)(() => {
    refetch();
  }, [refetch]);
  const inferenceEndpoint = {
    config: {
      inferenceId: selectedInferenceEndpoint.inference_id,
      taskType: selectedInferenceEndpoint.task_type,
      provider: selectedInferenceEndpoint.service,
      ...((_selectedInferenceEnd = selectedInferenceEndpoint.task_settings) !== null && _selectedInferenceEnd !== void 0 && _selectedInferenceEnd.headers ? {
        headers: (_selectedInferenceEnd2 = selectedInferenceEndpoint.task_settings) === null || _selectedInferenceEnd2 === void 0 ? void 0 : _selectedInferenceEnd2.headers
      } : {}),
      providerConfig: {
        ...(0, _objectUtils.flattenObject)(selectedInferenceEndpoint.service_settings),
        // NOTE: The below is a workaround for anthropic max_tokens handling.
        // Anthropic is unique in that it requires max_tokens to be stored as part of the task_settings instead of the usual service_settings - which we populate the providerConfig from.
        ...((_selectedInferenceEnd3 = selectedInferenceEndpoint.task_settings) !== null && _selectedInferenceEnd3 !== void 0 && _selectedInferenceEnd3.max_tokens && selectedInferenceEndpoint.service === _inferenceEndpointUiCommon.ServiceProviderKeys.anthropic ? {
          max_tokens: (_selectedInferenceEnd4 = selectedInferenceEndpoint.task_settings) === null || _selectedInferenceEnd4 === void 0 ? void 0 : _selectedInferenceEnd4.max_tokens
        } : {})
      }
    },
    secrets: {
      providerSecrets: {}
    }
  };
  return /*#__PURE__*/_react.default.createElement(_inference_flyout_wrapper.InferenceFlyoutWrapper, {
    onFlyoutClose: onFlyoutClose,
    http: http,
    toasts: toasts,
    isEdit: true,
    enforceAdaptiveAllocations: !!serverless,
    onSubmitSuccess: onEditSuccess,
    inferenceEndpoint: inferenceEndpoint,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  });
};
exports.EditInferenceFlyout = EditInferenceFlyout;