"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateMappings = void 0;
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../constants");
var _use_kibana = require("../use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUpdateMappings = () => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    mutate: updateIndexMappings,
    ...rest
  } = (0, _reactQuery.useMutation)({
    mutationKey: [_constants.MutationKeys.SearchIndicesUpdateMappings],
    mutationFn: async input => http.put(`/api/index_management/mapping/${encodeURIComponent(input.indexName)}`, {
      body: JSON.stringify(input.fields)
    }),
    onSettled: (data, error, variables) => {
      queryClient.invalidateQueries([_constants.QueryKeys.FetchMapping, variables.indexName]);
    }
  });
  return {
    updateIndexMappings,
    ...rest
  };
};
exports.useUpdateMappings = useUpdateMappings;