"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryKeys = exports.PARENT_BREADCRUMB = exports.MutationKeys = exports.INDEX_PLACEHOLDER = exports.ELSER_ON_ML_NODE_INFERENCE_ENDPOINT_ID = exports.ELSER_ON_EIS_INFERENCE_ENDPOINT_ID = exports.DEFAULT_DOCUMENT_PAGE_SIZE = exports.BREADCRUMB_TEXT = exports.API_KEY_PLACEHOLDER = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let QueryKeys = exports.QueryKeys = /*#__PURE__*/function (QueryKeys) {
  QueryKeys["FetchIndex"] = "fetchIndex";
  QueryKeys["FetchMapping"] = "fetchMapping";
  QueryKeys["FetchOnboardingToken"] = "fetchOnboardingToken";
  QueryKeys["FetchSearchIndicesStatus"] = "fetchSearchIndicesStatus";
  QueryKeys["FetchUserStartPrivileges"] = "fetchUserStartPrivileges";
  QueryKeys["SearchDocuments"] = "searchDocuments";
  QueryKeys["FetchSampleDataStatus"] = "fetchSampleDataStatus";
  QueryKeys["IngestSampleData"] = "ingestSampleData";
  return QueryKeys;
}({});
let MutationKeys = exports.MutationKeys = /*#__PURE__*/function (MutationKeys) {
  MutationKeys["SearchIndicesCreateIndex"] = "searchIndicesCreateIndex";
  MutationKeys["SearchIndicesDeleteDocument"] = "searchIndicesDeleteDocument";
  MutationKeys["SearchIndicesUpdateMappings"] = "searchIndicesUpdateMappings";
  return MutationKeys;
}({});
const API_KEY_PLACEHOLDER = exports.API_KEY_PLACEHOLDER = 'YOUR_API_KEY';
const INDEX_PLACEHOLDER = exports.INDEX_PLACEHOLDER = 'my-index';
const DEFAULT_DOCUMENT_PAGE_SIZE = exports.DEFAULT_DOCUMENT_PAGE_SIZE = 10;
const BREADCRUMB_TEXT = exports.BREADCRUMB_TEXT = _i18n.i18n.translate('xpack.searchIndices.indexManagement.breadcrumb', {
  defaultMessage: 'Build'
});
const PARENT_BREADCRUMB = exports.PARENT_BREADCRUMB = {
  text: BREADCRUMB_TEXT
};
const ELSER_ON_ML_NODE_INFERENCE_ENDPOINT_ID = exports.ELSER_ON_ML_NODE_INFERENCE_ENDPOINT_ID = '.elser-2-elasticsearch';
const ELSER_ON_EIS_INFERENCE_ENDPOINT_ID = exports.ELSER_ON_EIS_INFERENCE_ENDPOINT_ID = '.elser-2-elastic';