"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIndexPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _doc_links = require("../../../../common/doc_links");
var _use_kibana = require("../../../hooks/use_kibana");
var _types = require("../../../types");
var _callout_browse_integration_stack = require("./callout_browse_integration_stack");
var _callout_create_o11y_space_stack = require("./callout_create_o11y_space_stack");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/shared/create_index_panel/create_index_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_WIDTH = '980px';
const CreateIndexPanel = ({
  children,
  createIndexView,
  onChangeView,
  onClose,
  showSkip,
  title
}) => {
  var _cloud$isServerlessEn;
  const {
    cloud,
    http
  } = (0, _use_kibana.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isServerless = (_cloud$isServerlessEn = cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled) !== null && _cloud$isServerlessEn !== void 0 ? _cloud$isServerlessEn : false;
  const o11yTrialLink = (0, _react.useMemo)(() => {
    if (cloud && cloud.isServerlessEnabled) {
      var _cloud$projectsUrl;
      const baseUrl = (_cloud$projectsUrl = cloud === null || cloud === void 0 ? void 0 : cloud.projectsUrl) !== null && _cloud$projectsUrl !== void 0 ? _cloud$projectsUrl : 'https://cloud.elastic.co/projects/';
      return `${baseUrl}create/observability/start`;
    }
    return http.basePath.prepend('/app/observability/onboarding');
  }, [cloud, http]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false,
    hasBorder: true,
    style: {
      maxWidth: MAX_WIDTH,
      margin: '0 auto',
      padding: euiTheme.size.l,
      paddingTop: euiTheme.size.m
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "closeCreateIndex",
    iconType: "cross",
    onClick: onClose,
    color: "text",
    "aria-label": _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.closeAriaLabel', {
      defaultMessage: 'Close create index'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "none",
    style: {
      paddingLeft: euiTheme.size.m,
      paddingRight: euiTheme.size.m
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoElasticsearch",
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.pageTitle', {
    defaultMessage: 'Elasticsearch'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.pageDescription', {
    defaultMessage: 'Get started with Elasticsearch'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 19
    }
  }, title !== null && title !== void 0 ? title : _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.defaultTitle', {
    defaultMessage: 'Create an index'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.viewSelect.legend', {
      defaultMessage: 'Create index view selection'
    }),
    options: [{
      id: _types.CreateIndexViewMode.UI,
      label: _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.viewSelect.ui', {
        defaultMessage: 'UI'
      }),
      'data-test-subj': 'createIndexUIViewBtn'
    }, {
      id: _types.CreateIndexViewMode.Code,
      label: _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.viewSelect.code', {
        defaultMessage: 'Code'
      }),
      'data-test-subj': 'createIndexCodeViewBtn'
    }],
    buttonSize: "compressed",
    idSelected: createIndexView,
    onChange: onChangeView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.description', {
    defaultMessage: 'An index stores your data and defines the schema, or field mappings, for your searches'
  }))), children)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
    textAlign: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.observabilityCallout.title', {
    defaultMessage: 'Looking to store your logs or metrics data?'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 13
    }
  }, isServerless ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    iconSide: "right",
    iconType: "popout",
    "data-test-subj": "analyzeLogsBtn",
    href: _doc_links.docLinks.analyzeLogs,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.observabilityCallout.logs.button', {
    defaultMessage: 'Collect and analyze logs'
  })) : /*#__PURE__*/_react.default.createElement(_callout_browse_integration_stack.CreateIndexCalloutBrowseIntegrationBtn, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    textAlign: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("small", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.observabilityCallout.logs.subTitle', {
    defaultMessage: 'Explore Logstash and Beats'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 15
    }
  }, "or")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 13
    }
  }, isServerless ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    iconSide: "right",
    iconType: "popout",
    "data-test-subj": "startO11yTrialBtn",
    href: o11yTrialLink,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.observabilityCallout.o11yTrial.button', {
    defaultMessage: 'Start an Observability trial'
  })) : /*#__PURE__*/_react.default.createElement(_callout_create_o11y_space_stack.CreateIndexPanelCreateO11ySpaceBtn, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    textAlign: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("small", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.observabilityCallout.o11yTrial.subTitle', {
    defaultMessage: 'Powerful performance monitoring'
  }))))))), showSkip === true && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    "data-test-subj": "createIndexSkipBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.skipLabel', {
    defaultMessage: 'Skip'
  })))));
};
exports.CreateIndexPanel = CreateIndexPanel;