"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerStatsRoutes = void 0;
var _routes = require("../../common/routes");
var _size_stats = require("../lib/size_stats");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerStatsRoutes = (router, _logger, {
  isServerless
}) => {
  router.get({
    path: _routes.GET_STATS_ROUTE,
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the scoped ES client'
      }
    },
    validate: {},
    options: {
      access: 'internal'
    }
  }, async (context, _request, response) => {
    const client = (await context.core).elasticsearch.client;
    const stats = await (0, _size_stats.fetchSizeStats)(client, isServerless);
    return response.ok({
      headers: {
        'content-type': 'application/json'
      },
      body: stats
    });
  });
};
exports.registerStatsRoutes = registerStatsRoutes;