"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetLicenseInfo = void 0;
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _react = require("react");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetLicenseInfo = () => {
  const {
    services: {
      licensing
    }
  } = (0, _use_kibana.useKibana)();
  const license = (0, _useObservable.default)(licensing.license$, null);
  const {
    isTrial,
    licenseType
  } = (0, _react.useMemo)(() => ({
    isTrial: license && license.isAvailable && license.isActive && license.type === 'trial',
    licenseType: license === null || license === void 0 ? void 0 : license.type
  }), [license]);
  return {
    isTrial,
    licenseType
  };
};
exports.useGetLicenseInfo = useGetLicenseInfo;