"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAuthenticatedUser = void 0;
var _react = require("react");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLOUD_USER_ADMIN_ROLE = 'admin';
const CLOUD_USER_BILLING_ADMIN_ROLE = '_ec_billing_admin';
const useAuthenticatedUser = () => {
  var _user$roles$includes, _user$roles$includes2;
  const {
    services: {
      security: {
        authc
      }
    }
  } = (0, _use_kibana.useKibana)();
  const [user, setUser] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const getCurrentUser = async () => {
      try {
        const authenticatedUser = await authc.getCurrentUser();
        setUser(authenticatedUser);
      } catch {
        setUser(undefined);
      }
    };
    getCurrentUser();
  }, [authc]);
  return {
    user,
    isAdmin: (_user$roles$includes = user === null || user === void 0 ? void 0 : user.roles.includes(CLOUD_USER_ADMIN_ROLE)) !== null && _user$roles$includes !== void 0 ? _user$roles$includes : false,
    isBillingAdmin: (_user$roles$includes2 = user === null || user === void 0 ? void 0 : user.roles.includes(CLOUD_USER_BILLING_ADMIN_ROLE)) !== null && _user$roles$includes2 !== void 0 ? _user$roles$includes2 : false
  };
};
exports.useAuthenticatedUser = useAuthenticatedUser;