"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentCount = void 0;
var _react = require("react");
var _use_kibana = require("../use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAgentCount = () => {
  const {
    services: {
      onechat
    }
  } = (0, _use_kibana.useKibana)();
  const [toolCount, setToolCount] = (0, _react.useState)(0);
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [isError, setIsError] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    onechat === null || onechat === void 0 ? void 0 : onechat.tools.list().then(tools => {
      setToolCount(tools.length);
    }).catch(() => {
      setIsError(true);
    }).finally(() => {
      setIsLoading(false);
    });
  }, [onechat]);
  return {
    tools: toolCount,
    agents: 0,
    isLoading,
    isError
  };
};
exports.useAgentCount = useAgentCount;