"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchHomepagePage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _use_authenticated_user = require("../../hooks/use_authenticated_user");
var _use_get_license_info = require("../../hooks/use_get_license_info");
var _use_kibana = require("../../hooks/use_kibana");
var _basic_metric_badges = require("./basic_metric_badges");
var _connect_to_elasticsearch = require("./connect_to_elasticsearch");
var _license_badge = require("./license_badge");
var _search_homepage_body = require("./search_homepage_body");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/search_homepage/search_homepage.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchHomepagePage = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    services: {
      console: consolePlugin,
      history,
      searchNavigation,
      cloud
    }
  } = (0, _use_kibana.useKibana)();
  const {
    isTrial
  } = (0, _use_get_license_info.useGetLicenseInfo)();
  const {
    user,
    isAdmin
  } = (0, _use_authenticated_user.useAuthenticatedUser)();
  (0, _react.useEffect)(() => {
    if (searchNavigation) {
      searchNavigation.breadcrumbs.setSearchBreadCrumbs([{
        text: _i18n.i18n.translate('xpack.searchHomepage.breadcrumbs.home', {
          defaultMessage: 'Home'
        })
      }]);
    }
  }, [searchNavigation]);
  const embeddableConsole = (0, _react.useMemo)(() => consolePlugin !== null && consolePlugin !== void 0 && consolePlugin.EmbeddableConsole ? /*#__PURE__*/_react.default.createElement(consolePlugin.EmbeddableConsole, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 47
    }
  }) : null, [consolePlugin]);
  const projectManagementUrl = (0, _react.useMemo)(() => {
    if (cloud && cloud.isServerlessEnabled) {
      var _cloud$projectsUrl;
      const baseUrl = (_cloud$projectsUrl = cloud.projectsUrl) !== null && _cloud$projectsUrl !== void 0 ? _cloud$projectsUrl : 'https://cloud.elastic.co/projects/';
      const dirPath = cloud.serverless.projectId ? `elasticsearch/${cloud.serverless.projectId}` : '';
      return `${baseUrl}${dirPath}`;
    }
  }, [cloud]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    offset: 0,
    restrictWidth: true,
    "data-test-subj": "search-homepage",
    grow: false,
    solutionNav: searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.useClassicNavigation(history),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    restrictWidth: true,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    gutterSize: "s",
    "data-test-subj": "searchHomepageHeaderLeftsideGroup",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 19
    }
  }, user !== null && user !== void 0 && user.full_name ? _i18n.i18n.translate('xpack.searchHomepage.welcome.title', {
    defaultMessage: 'Welcome, {username}',
    values: {
      username: user.full_name
    }
  }) : _i18n.i18n.translate('xpack.searchHomepage.welcome.title.default', {
    defaultMessage: 'Welcome'
  })))), (isTrial || !(cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled) && !(cloud !== null && cloud !== void 0 && cloud.isCloudEnabled)) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_license_badge.LicenseBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 19
    }
  })), isAdmin && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "searchHomepageSearchHomepagePageManageSubscriptionLink",
    external: true,
    href: projectManagementUrl,
    color: "text",
    css: (0, _react2.css)({
      padding: euiTheme.size.s
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.searchHomepage.searchHomepagePage.manageSubscriptionLinkLabel', {
    defaultMessage: 'Manage'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_connect_to_elasticsearch.ConnectToElasticsearch, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_basic_metric_badges.BasicMetricBadges, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_search_homepage_body.SearchHomepageBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }), embeddableConsole);
};
exports.SearchHomepagePage = SearchHomepagePage;