"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricPanels = exports.METRIC_PANEL_ITEMS = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _common = require("../../../common");
var _use_asset_base_path = require("../../hooks/use_asset_base_path");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/search_homepage/metric_panels.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PANEL_TYPES = ['discover', 'dashboards', 'agentBuilder', 'workflows', 'machineLearning', 'dataManagement'];
const METRIC_PANEL_ITEMS = exports.METRIC_PANEL_ITEMS = [{
  getImageUrl: assetBasePath => `${assetBasePath}/search_lake.svg`,
  metricDescription: _i18n.i18n.translate('xpack.searchHomepage.metricPanels.empty.discover.desc', {
    defaultMessage: 'Search and filter documents, analyze fields, visualize patterns, and save findings for later.'
  }),
  metricTitle: _i18n.i18n.translate('xpack.searchHomepage.metricPanels.empty.discover.title', {
    defaultMessage: 'Discover'
  }),
  type: 'discover',
  onPanelClick: ({
    application
  }) => {
    application.navigateToApp('discover');
  },
  dataTestSubj: 'searchHomepageNavLinks-discover'
}, {
  getImageUrl: assetBasePath => `${assetBasePath}/search_data_vis.svg`,
  metricDescription: _i18n.i18n.translate('xpack.searchHomepage.metricPanels.empty.dashboards.desc', {
    defaultMessage: 'Analyze all of your Elastic data in one place by creating a dashboard and adding visualizations.'
  }),
  metricTitle: _i18n.i18n.translate('xpack.searchHomepage.metricPanels.empty.dashboards.title', {
    defaultMessage: 'Dashboards'
  }),
  type: 'dashboards',
  onPanelClick: ({
    application
  }) => {
    application.navigateToApp('dashboards');
  },
  dataTestSubj: 'searchHomepageNavLinks-dashboards'
}, {
  getImageUrl: assetBasePath => `${assetBasePath}/search_agents.svg`,
  metricDescription: _i18n.i18n.translate('xpack.searchHomepage.metricPanels.empty.agents.desc', {
    defaultMessage: 'Utilize AI-powered capabilities to build and interact with agents alongside your Elasticsearch data.'
  }),
  metricTitle: _i18n.i18n.translate('xpack.searchHomepage.metricPanels.empty.agents.title', {
    defaultMessage: 'Agent Builder'
  }),
  type: 'agentBuilder',
  onPanelClick: ({
    application
  }) => {
    application.navigateToApp('agent_builder');
  },
  dataTestSubj: 'searchHomepageNavLinks-agentBuilder'
}, {
  type: 'workflows',
  getImageUrl: assetBasePath => `${assetBasePath}/search_relevance.svg`,
  metricDescription: _i18n.i18n.translate('xpack.searchHomepage.metricPanels.empty.workflows.desc', {
    defaultMessage: 'Create intelligent workflows that turn Elastic insights into automated actions across your entire tech stack.'
  }),
  metricTitle: _i18n.i18n.translate('xpack.searchHomepage.metricPanels.empty.workflow.title', {
    defaultMessage: 'Workflows'
  }),
  onPanelClick: ({
    application
  }) => {
    application.navigateToApp('workflows');
  },
  dataTestSubj: 'searchHomepageNavLinks-workflows'
}, {
  type: 'machineLearning',
  getImageUrl: assetBasePath => `${assetBasePath}/search_machinelearning.svg`,
  metricDescription: _i18n.i18n.translate('xpack.searchHomepage.metricPanels.empty.machineLearning.desc', {
    defaultMessage: 'Analyze and visualize your data to generate models for determining patterns of behavior.'
  }),
  metricTitle: _i18n.i18n.translate('xpack.searchHomepage.metricPanels.empty.machineLearning.title', {
    defaultMessage: 'Machine Learning'
  }),
  onPanelClick: ({
    application
  }) => {
    application.navigateToApp('ml', {
      path: 'overview'
    });
  },
  dataTestSubj: 'searchHomepageNavLinks-machineLearning'
}, {
  type: 'dataManagement',
  getImageUrl: assetBasePath => `${assetBasePath}/search_indexing_folder.svg`,
  metricDescription: _i18n.i18n.translate('xpack.searchHomepage.metricPanels.empty.dataManagement.desc', {
    defaultMessage: 'Manage your Elasticsearch indices, ingest pipelines and search relevance tooling.'
  }),
  metricTitle: _i18n.i18n.translate('xpack.searchHomepage.metricPanels.empty.dataManagement.title', {
    defaultMessage: 'Data Management'
  }),
  onPanelClick: ({
    application
  }) => {
    application.navigateToApp('management', {
      path: 'data/index_management'
    });
  },
  dataTestSubj: 'searchHomepageNavLinks-dataManagement'
}];
const MetricPanelEmpty = ({
  panel
}) => {
  const {
    services: {
      share,
      application
    }
  } = (0, _use_kibana.useKibana)();
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    getImageUrl,
    metricTitle,
    metricDescription,
    onPanelClick,
    dataTestSubj
  } = panel;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasBorder: true,
    onClick: () => onPanelClick && onPanelClick({
      share,
      application
    }),
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: true,
    css: (0, _react2.css)({
      backgroundColor: euiTheme.colors.backgroundBaseSubdued,
      minHeight: `${euiTheme.base * 7}px`
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    justifyContent: "center",
    gutterSize: "s",
    css: (0, _react2.css)({
      height: '100%'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    size: euiTheme.size.xxxxl,
    src: getImageUrl(assetBasePath),
    alt: "",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    css: (0, _react2.css)({
      minHeight: `${euiTheme.base * 8}px`
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 15
    }
  }, metricTitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 15
    }
  }, metricDescription))))));
};
const MetricPanels = () => {
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const isWorkflowsUiEnabled = services.uiSettings.get(_common.WORKFLOWS_UI_SETTING_ENABLED_ID, false);
  const panels = isWorkflowsUiEnabled ? METRIC_PANEL_ITEMS : METRIC_PANEL_ITEMS.filter(p => p.type !== 'workflows');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "l",
    columns: 3,
    "data-test-subj": "searchHomepageNavLinksTabGrid",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 5
    }
  }, panels.map((panel, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: panel.type + '-' + index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(MetricPanelEmpty, {
    panel: panel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 11
    }
  }))));
};
exports.MetricPanels = MetricPanels;