"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SemanticSearch = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _ai_search_workflow = require("./ai_search_workflow");
var _use_asset_base_path = require("../../hooks/use_asset_base_path");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/ai_search_capabilities/semantic_search.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SemanticSearch = () => {
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  const semanticSearchText = {
    image: `${assetBasePath}/semantic_search.svg`,
    imageAlt: _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.semanticSearch.imageAlt', {
      defaultMessage: 'Semantic search'
    }),
    heading: _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.semanticSearch.title', {
      defaultMessage: 'Enhance search accuracy with advanced semantic capabilities.'
    }),
    subheading: _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.semanticSearch.description', {
      defaultMessage: 'Leverage the semantic_text field and ELSER machine learning model for enhanced data analysis.'
    }),
    featureBullets: [_i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.semanticSearch.firstLine', {
      defaultMessage: 'Use Elastic’s inference service or connect your own model provider'
    }), _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.semanticSearch.SecondLine', {
      defaultMessage: 'Default chunking strategies or customize your own'
    }), _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.semanticSearch.ThirdLine', {
      defaultMessage: 'Combine semantic capabilities with traditional search methods.'
    })],
    buttonLabel: _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.semanticSearch.createSemanticOptimizedIndex', {
      defaultMessage: 'Create a semantic optimized index'
    }),
    dataTestSubj: 'createSemanticOptimizedIndexButton',
    workflow: 'semantic'
  };
  return /*#__PURE__*/_react.default.createElement(_ai_search_workflow.AISearchWorkflow, {
    capability: semanticSearchText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 10
    }
  });
};
exports.SemanticSearch = SemanticSearch;