"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelinePanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _flyout_panel = require("./flyout_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-search-connectors/components/sync_jobs/pipeline_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const PipelinePanel = ({
  pipeline
}) => {
  const items = [{
    setting: _i18n.i18n.translate('searchConnectors.index.syncJobs.pipeline.name', {
      defaultMessage: 'Pipeline name'
    }),
    value: pipeline.name
  }, {
    setting: _i18n.i18n.translate('searchConnectors.index.syncJobs.pipeline.extractBinaryContent', {
      defaultMessage: 'Extract binary content'
    }),
    value: pipeline.extract_binary_content
  }, {
    setting: _i18n.i18n.translate('searchConnectors.index.syncJobs.pipeline.reduceWhitespace', {
      defaultMessage: 'Reduce whitespace'
    }),
    value: pipeline.reduce_whitespace
  }, {
    setting: _i18n.i18n.translate('searchConnectors.index.syncJobs.pipeline.runMlInference', {
      defaultMessage: 'Machine learning inference'
    }),
    value: pipeline.run_ml_inference
  }];
  const columns = [{
    field: 'setting',
    name: _i18n.i18n.translate('searchConnectors.index.syncJobs.pipeline.setting', {
      defaultMessage: 'Pipeline setting'
    })
  }, {
    field: 'value',
    name: _i18n.i18n.translate('searchConnectors.index.syncJobs.documents.value', {
      defaultMessage: 'Value'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_flyout_panel.FlyoutPanel, {
    title: _i18n.i18n.translate('searchConnectors.index.syncJobs.pipeline.title', {
      defaultMessage: 'Pipeline'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: items,
    tableCaption: _i18n.i18n.translate('searchConnectors.index.syncJobs.pipeline.settingsTableCaption', {
      defaultMessage: 'Pipeline settings and values'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }));
};
exports.PipelinePanel = PipelinePanel;