"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavControlInitiator = void 0;
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _react = _interopRequireWildcard(require("react"));
var _aiAssistantCommon = require("@kbn/ai-assistant-common");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_assistant/public/components/nav_control/lazy_nav_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LazyNavControlWithProvider = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('.'))).then(m => ({
  default: m.NavControlWithProvider
})));
const NavControlInitiator = ({
  coreStart,
  pluginsStart
}) => {
  const [isClassicExperience, setIsClassicExperience] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    const sub = coreStart.settings.client.get$(_managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE).subscribe(chatExperience => {
      setIsClassicExperience(chatExperience === _aiAssistantCommon.AIChatExperience.Classic);
    });
    return () => {
      sub.unsubscribe();
    };
  }, [coreStart.settings.client]);

  // Only render nav control for Classic chat experience
  // AI Agents experience uses OnechatNavControl instead
  if (!isClassicExperience) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(LazyNavControlWithProvider, {
    coreStart: coreStart,
    pluginsStart: pluginsStart,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 10
    }
  });
};
exports.NavControlInitiator = NavControlInitiator;