"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectTaggingPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _constants = require("../common/constants");
var _capabilities = require("../common/capabilities");
var _services = require("./services");
var _ui_api = require("./ui_api");
var _config = require("./config");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class SavedObjectTaggingPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "tagClient", void 0);
    (0, _defineProperty2.default)(this, "tagCache", void 0);
    (0, _defineProperty2.default)(this, "assignmentService", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    this.config = new _config.SavedObjectsTaggingClientConfig(context.config.get());
  }
  setup(core, {
    management,
    savedObjectsTaggingOss
  }) {
    const kibanaSection = management.sections.section.kibana;
    const title = _i18n.i18n.translate('xpack.savedObjectsTagging.management.sectionLabel', {
      defaultMessage: 'Tags'
    });
    kibanaSection.registerApp({
      id: _constants.tagManagementSectionId,
      title,
      order: 1.5,
      mount: async mountParams => {
        const {
          mountSection
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./management')));
        return mountSection({
          tagClient: this.tagClient,
          tagCache: this.tagCache,
          assignmentService: this.assignmentService,
          core,
          mountParams,
          title
        });
      }
    });
    savedObjectsTaggingOss.registerTaggingApi(core.getStartServices().then(([_core, _deps, startContract]) => startContract));
    return {};
  }
  start({
    http,
    application,
    analytics,
    ...startServices
  }) {
    this.tagCache = new _services.TagsCache({
      refreshHandler: () => this.tagClient.getAll({
        asSystemRequest: true
      }),
      refreshInterval: this.config.cacheRefreshInterval
    });
    this.tagClient = new _services.TagsClient({
      analytics,
      http,
      changeListener: this.tagCache
    });
    this.assignmentService = new _services.TagAssignmentService({
      http
    });

    // do not fetch tags on anonymous page
    if (!http.anonymousPaths.isAnonymous(window.location.pathname)) {
      // we don't need to wait for this to resolve.
      this.tagCache.initialize().catch(() => {
        // cache is resilient to initial load failure. We just need to catch to avoid unhandled promise rejection
      });
    }
    return {
      client: this.tagClient,
      cache: this.tagCache,
      ui: (0, _ui_api.getUiApi)({
        ...startServices,
        cache: this.tagCache,
        client: this.tagClient,
        capabilities: (0, _capabilities.getTagsCapabilities)(application.capabilities)
      })
    };
  }
  stop() {
    if (this.tagCache) {
      this.tagCache.stop();
    }
  }
}
exports.SavedObjectTaggingPlugin = SavedObjectTaggingPlugin;