"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditTagModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _tags = require("../../services/tags");
var _create_or_edit_modal = require("./create_or_edit_modal");
var _utils = require("./utils");
var _use_validation = require("./use_validation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/saved_objects_tagging/public/components/edition_modal/edit_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getAttributes = tag => {
  const {
    id,
    managed,
    ...attributes
  } = tag;
  return attributes;
};
const EditTagModal = ({
  tag,
  onSave,
  onClose,
  tagClient,
  notifications
}) => {
  const [tagAttributes, setTagAttributes] = (0, _react.useState)(getAttributes(tag));
  const {
    validation,
    setValidation,
    onNameChange,
    isValidating,
    validation$
  } = (0, _use_validation.useValidation)({
    tagAttributes,
    tagClient
  });
  const setField = (0, _react.useCallback)(field => value => {
    setTagAttributes(current => ({
      ...current,
      [field]: value
    }));
  }, []);
  const onSubmit = (0, _react.useCallback)(async () => {
    const {
      hasDuplicateNameError
    } = await (0, _rxjs.lastValueFrom)(validation$.pipe((0, _rxjs.first)(v => v.isValidating === false)));
    if (hasDuplicateNameError) {
      return;
    }
    const clientValidation = (0, _utils.validateTag)(tagAttributes);
    setValidation(clientValidation);
    if (!clientValidation.valid) {
      return;
    }
    try {
      const createdTag = await tagClient.update(tag.id, tagAttributes);
      onSave(createdTag);
    } catch (e) {
      // if e is IHttpFetchError, actual server error payload is in e.body
      if ((0, _tags.isServerValidationError)(e.body)) {
        setValidation(e.body.attributes);
      } else {
        notifications.toasts.addDanger({
          title: _i18n.i18n.translate('xpack.savedObjectsTagging.editTagErrorTitle', {
            defaultMessage: 'An error occurred editing tag'
          }),
          text: e.body.message
        });
      }
    }
  }, [validation$, tagAttributes, setValidation, tagClient, tag.id, onSave, notifications.toasts]);
  return /*#__PURE__*/_react.default.createElement(_create_or_edit_modal.CreateOrEditModal, {
    onClose: onClose,
    onSubmit: onSubmit,
    onNameChange: onNameChange,
    mode: 'edit',
    tag: tagAttributes,
    setField: setField,
    validation: validation,
    isValidating: isValidating,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 5
    }
  });
};
exports.EditTagModal = EditTagModal;