"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processObject = void 0;
var _configSchema = require("@kbn/config-schema");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const {
  META_FIELD_X_OAS_OPTIONAL
} = _configSchema.metaFields;
const isNullable = schema => {
  return schema.nullable === true;
};
const hasDefault = schema => {
  return schema.default != null;
};
const populateRequiredFields = schema => {
  if (!schema.properties) return;
  const required = [];
  const entries = Object.entries(schema.properties);
  for (const [key, value] of entries) {
    if (META_FIELD_X_OAS_OPTIONAL in value) {
      (0, _utils.deleteField)(value, META_FIELD_X_OAS_OPTIONAL);
    } else if (hasDefault(value) || Boolean(value.anyOf && value.anyOf.some(v => isNullable(v)))) {
      // Must not be added to the required array
    } else {
      required.push(key);
    }
  }
  if (required.length > 0) schema.required = required;
};
const removeNeverType = schema => {
  if (!schema.properties) return;
  for (const [key, value] of Object.entries(schema.properties)) {
    if (Object.keys(value).length === 1 && 'not' in value) {
      delete schema.properties[key];
    }
  }
};
const processObject = schema => {
  (0, _utils.stripBadDefault)(schema);
  removeNeverType(schema);
  populateRequiredFields(schema);
};
exports.processObject = processObject;