"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.degradedDocsParamsSchema = void 0;
var _alertingComparators = require("@kbn/alerting-comparators");
var _configSchema = require("@kbn/config-schema");
var _utils = require("../common/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const comparators = Object.values(_alertingComparators.COMPARATORS);
const searchConfigSchema = _configSchema.schema.object({
  index: _configSchema.schema.string()
});
const degradedDocsParamsSchema = exports.degradedDocsParamsSchema = _configSchema.schema.object({
  timeUnit: _configSchema.schema.string(),
  timeSize: _configSchema.schema.number(),
  threshold: _configSchema.schema.arrayOf(_configSchema.schema.number()),
  comparator: (0, _utils.oneOfLiterals)(comparators),
  groupBy: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  searchConfiguration: searchConfigSchema
});