"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pagingStrategySchema = exports.idSchema = void 0;
exports.validateJobParams = validateJobParams;
exports.validateTimezone = validateTimezone;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _zod = require("@kbn/zod");
var _dompurify = _interopRequireDefault(require("dompurify"));
var _jsdom = require("jsdom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const window = new _jsdom.JSDOM('').window;
const purify = (0, _dompurify.default)(window);
const sanitizeString = input => {
  if (typeof input !== 'string') {
    return '';
  }
  return purify.sanitize(input, {
    ALLOWED_TAGS: [],
    ALLOWED_ATTR: [],
    KEEP_CONTENT: true,
    SAFE_FOR_TEMPLATES: true,
    RETURN_TRUSTED_TYPE: false
  });
};
function validateTimezone(timezone) {
  if (_momentTimezone.default.tz.zone(timezone) != null) {
    return;
  }
  return 'string is not a valid timezone: ' + timezone;
}
const timezoneSchema = _zod.z.string().refine(val => validateTimezone(val) === undefined, {
  message: 'Invalid timezone'
});
const dimensionsSchema = _zod.z.object({
  height: _zod.z.number().positive().max(14400),
  width: _zod.z.number().positive().max(14400)
}).strict();
const idSchema = exports.idSchema = _zod.z.enum(['preserve_layout', 'print', 'canvas', 'png']); // "png" is used in some tests, could be a legacy value

const layoutSchema = _zod.z.object({
  id: idSchema.optional(),
  dimensions: dimensionsSchema.optional(),
  zoom: _zod.z.number().positive().max(1000).optional(),
  selectors: _zod.z.object({
    screenshot: _zod.z.string().max(1024).optional(),
    renderComplete: _zod.z.string().max(1024).optional(),
    renderError: _zod.z.string().max(1024).optional(),
    renderErrorAttribute: _zod.z.string().max(1024).optional(),
    itemsCountAttribute: _zod.z.string().max(1024).optional(),
    timefilterDurationAttribute: _zod.z.string().max(1024).optional()
  }).strict().optional()
}).strict();
const objectTypeSchema = _zod.z.string().max(256).transform(objectType => sanitizeString(objectType));
const titleSchema = _zod.z.string().max(2048).transform(title => sanitizeString(title));
const versionSchema = _zod.z.string().max(32).transform(version => sanitizeString(version));
const forceNowSchema = _zod.z.string().max(32).transform(forceNow => sanitizeString(forceNow));
const pagingStrategySchema = exports.pagingStrategySchema = _zod.z.enum(['pit', 'scroll']);
const locatorObjectSchema = _zod.z.object({
  id: _zod.z.string().max(1024).optional(),
  version: _zod.z.string().max(32).optional(),
  params: _zod.z.record(_zod.z.any()).optional()
});
const locatorParamsSchema = _zod.z.array(locatorObjectSchema).max(1).or(locatorObjectSchema);
const relativeUrlSchema = _zod.z.string().max(4096);
const relativeUrlsSchema = _zod.z.array(relativeUrlSchema).max(100);
const jobParamsSchema = _zod.z.object({
  browserTimezone: timezoneSchema.optional(),
  objectType: objectTypeSchema.optional(),
  title: titleSchema.optional(),
  version: versionSchema.optional(),
  layout: layoutSchema.optional(),
  forceNow: forceNowSchema.optional(),
  pagingStrategy: pagingStrategySchema.optional(),
  // for CSV reports
  locatorParams: locatorParamsSchema.nullable().optional(),
  // this is for CSV v2 compatibility
  searchSource: _zod.z.record(_zod.z.string(), _zod.z.any()).optional(),
  // this is for CSV v1 compatibility
  columns: _zod.z.array(_zod.z.string()).optional(),
  // this is for CSV v1 compatibility
  relativeUrls: relativeUrlsSchema.optional(),
  // used in tests could be legacy
  relativeUrl: relativeUrlSchema.optional(),
  // used in tests could be legacy
  isEsqlMode: _zod.z.boolean().optional() // for CSV reports
}).strict();
function validateJobParams(jobParams) {
  return jobParamsSchema.parse(jobParams);
}