"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ConfigSchema", {
  enumerable: true,
  get: function () {
    return _reportingServer.ConfigSchema;
  }
});
exports.config = void 0;
Object.defineProperty(exports, "createConfig", {
  enumerable: true,
  get: function () {
    return _create_config.createConfig;
  }
});
Object.defineProperty(exports, "registerUiSettings", {
  enumerable: true,
  get: function () {
    return _ui_settings.registerUiSettings;
  }
});
var _reportingServer = require("@kbn/reporting-server");
var _create_config = require("./create_config");
var _ui_settings = require("./ui_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const config = exports.config = {
  exposeToBrowser: {
    csv: {
      scroll: true,
      maxRows: true
    },
    poll: true,
    export_types: true,
    statefulSettings: true
  },
  schema: _reportingServer.ConfigSchema,
  deprecations: ({
    unused
  }) => [unused('csv.enablePanelActionDownload', {
    level: 'warning'
  }),
  // unused since 9.0
  unused('roles.enabled', {
    level: 'warning'
  }),
  // unused since 9.0
  unused('roles.allow', {
    level: 'warning'
  }),
  // unused since 9.0
  unused('queue.indexInterval', {
    level: 'warning'
  }),
  // unused since 8.15
  unused('capture.browser.chromium.maxScreenshotDimension', {
    level: 'warning'
  }),
  // unused since 7.8
  unused('capture.browser.type', {
    level: 'warning'
  }), unused('poll.jobCompletionNotifier.intervalErrorMultiplier', {
    level: 'warning'
  }),
  // unused since 7.10
  unused('poll.jobsRefresh.intervalErrorMultiplier', {
    level: 'warning'
  }),
  // unused since 7.10
  unused('capture.viewport', {
    level: 'warning'
  }) // deprecated as unused since 7.16
  ],
  exposeToUsage: {
    capture: {
      maxAttempts: true
    },
    csv: {
      maxSizeBytes: true,
      scroll: {
        size: true,
        duration: true
      }
    },
    kibanaServer: false,
    // show as [redacted]
    queue: {
      indexInterval: true,
      pollEnabled: true,
      timeout: true
    }
  }
};