"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScheduleReport = exports.getKey = void 0;
var _reactQuery = require("@kbn/react-query");
var _mutation_keys = require("../mutation_keys");
var _schedule_report = require("../apis/schedule_report");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getKey = exports.getKey = _mutation_keys.mutationKeys.scheduleReport;
const useScheduleReport = ({
  http
}) => {
  return (0, _reactQuery.useMutation)({
    mutationKey: getKey(),
    mutationFn: params => (0, _schedule_report.scheduleReport)({
      http,
      params
    })
  });
};
exports.useScheduleReport = useScheduleReport;