"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetScheduledList = exports.getKey = void 0;
var _reactQuery = require("@kbn/react-query");
var _reportingPublic = require("@kbn/reporting-public");
var _get_scheduled_reports_list = require("../apis/get_scheduled_reports_list");
var _query_keys = require("../query_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getKey = exports.getKey = _query_keys.queryKeys.getScheduledList;
const useGetScheduledList = props => {
  const {
    http
  } = (0, _reportingPublic.useKibana)().services;
  const {
    page = 1,
    perPage = 50,
    search
  } = props;
  return (0, _reactQuery.useQuery)({
    queryKey: getKey({
      page,
      perPage,
      search
    }),
    queryFn: () => (0, _get_scheduled_reports_list.getScheduledReportsList)({
      http,
      page,
      perPage,
      search
    }),
    keepPreviousData: true
  });
};
exports.useGetScheduledList = useGetScheduledList;