"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ReportSchedulesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _lodash = require("lodash");
var _queryString = require("query-string");
var _reportingCommon = require("@kbn/reporting-common");
var _reportingPublic = require("@kbn/reporting-public");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _utils = require("../utils");
var _use_get_scheduled_list = require("../hooks/use_get_scheduled_list");
var _job_utils = require("../../../common/job_utils");
var _report_schedule_indicator = require("./report_schedule_indicator");
var _use_bulk_disable = require("../hooks/use_bulk_disable");
var _translations = require("../../translations");
var _truncated_title = require("./truncated_title");
var _report_destructive_action_confirmation_modal = require("./report_destructive_action_confirmation_modal");
var _use_bulk_delete = require("../hooks/use_bulk_delete");
var _edit_scheduled_report_flyout = require("./edit_scheduled_report_flyout");
var _use_get_user_profile_query = require("../hooks/use_get_user_profile_query");
var _view_scheduled_report_flyout = require("./view_scheduled_report_flyout");
var _use_bulk_enable = require("../hooks/use_bulk_enable");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/reporting/public/management/components/report_schedules_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ReportSchedulesTable = () => {
  var _scheduledList$total;
  const {
    application: {
      capabilities
    },
    http,
    userProfile: userProfileService
  } = (0, _reportingPublic.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    data: userProfile
  } = (0, _use_get_user_profile_query.useGetUserProfileQuery)({
    userProfileService
  });
  const hasManageReportingPrivilege = (0, _react.useMemo)(() => {
    if (!capabilities) {
      return false;
    }
    return capabilities.manageReporting.show === true;
  }, [capabilities]);
  const canManageSchedule = (0, _react.useCallback)(item => {
    if (hasManageReportingPrivilege) return true;
    return item.created_by === (userProfile === null || userProfile === void 0 ? void 0 : userProfile.user.username);
  }, [hasManageReportingPrivilege, userProfile === null || userProfile === void 0 ? void 0 : userProfile.user.username]);
  const [selectedReport, setSelectedReport] = (0, _react.useState)(null);
  const [isConfigFlyOutOpen, setIsConfigFlyOutOpen] = (0, _react.useState)(false);
  const [isDisableModalConfirmationOpen, setIsDisableModalConfirmationOpen] = (0, _react.useState)(false);
  const [isDeleteModalConfirmationOpen, setIsDeleteModalConfirmationOpen] = (0, _react.useState)(false);
  const [queryParams, setQueryParams] = (0, _react.useState)({
    page: 1,
    perPage: 50,
    search: ''
  });
  const {
    data: scheduledList,
    isLoading,
    refetch: refreshScheduledReports
  } = (0, _use_get_scheduled_list.useGetScheduledList)({
    ...queryParams
  });
  const {
    mutateAsync: bulkDisableScheduledReports
  } = (0, _use_bulk_disable.useBulkDisable)();
  const {
    mutateAsync: bulkDeleteScheduledReports
  } = (0, _use_bulk_delete.useBulkDelete)();
  const {
    mutateAsync: bulkEnableScheduledReports
  } = (0, _use_bulk_enable.useBulkEnable)();
  const sortedList = (0, _lodash.orderBy)((scheduledList === null || scheduledList === void 0 ? void 0 : scheduledList.data) || [], ['created_at'], ['desc']);
  const tableColumns = [{
    field: 'payload.objectType',
    name: _i18n.i18n.translate('xpack.reporting.schedules.tableColumns.typeTitle', {
      defaultMessage: 'Type'
    }),
    width: '5%',
    render: objectType => /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      "data-test-subj": "reportObjectType",
      type: (0, _utils.guessAppIconTypeFromObjectType)(objectType),
      size: "s",
      content: (0, _utils.getDisplayNameFromObjectType)(objectType),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 9
      }
    })
  }, {
    field: 'title',
    name: _i18n.i18n.translate('xpack.reporting.schedules.tableColumns.reportTitle', {
      defaultMessage: 'Title'
    }),
    width: '22%',
    render: (title, item) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": `reportTitle`,
      onClick: () => {
        setReportAndOpenConfigFlyout(item);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_truncated_title.TruncatedTitle, {
      text: title,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 11
      }
    })),
    mobileOptions: {
      header: false,
      width: '100%'
    }
  }, {
    field: 'status',
    name: _i18n.i18n.translate('xpack.reporting.schedules.tableColumns.statusTitle', {
      defaultMessage: 'Status'
    }),
    width: '10%',
    render: (_status, item) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: item.enabled ? 'primary' : 'subdued',
        "data-test-subj": `reportStatus-${item.enabled ? 'active' : 'disabled'}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 154,
          columnNumber: 11
        }
      }, item.enabled ? _i18n.i18n.translate('xpack.reporting.schedules.status.active', {
        defaultMessage: 'Active'
      }) : _i18n.i18n.translate('xpack.reporting.schedules.status.disabled', {
        defaultMessage: 'Disabled'
      }));
    }
  }, {
    field: 'schedule',
    name: _i18n.i18n.translate('xpack.reporting.schedules.tableColumns.scheduleTitle', {
      defaultMessage: 'Schedule'
    }),
    width: '10%',
    render: schedule => /*#__PURE__*/_react.default.createElement(_report_schedule_indicator.ReportScheduleIndicator, {
      schedule: schedule,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 9
      }
    })
  }, {
    field: 'next_run',
    name: _i18n.i18n.translate('xpack.reporting.schedules.tableColumns.nextScheduleTitle', {
      defaultMessage: 'Next schedule'
    }),
    width: '20%',
    render: (nextRun, item) => {
      return item.enabled ? (0, _moment.default)(nextRun).format('YYYY-MM-DD @ hh:mm A') : '—';
    }
  }, {
    field: 'jobtype',
    width: '10%',
    name: _i18n.i18n.translate('xpack.reporting.schedules.tableColumns.fileType', {
      defaultMessage: 'File Type'
    }),
    render: jobtype => (0, _job_utils.prettyPrintJobType)(jobtype),
    mobileOptions: {
      show: false
    }
  }, {
    field: 'created_by',
    name: _i18n.i18n.translate('xpack.reporting.schedules.tableColumns.createdByTitle', {
      defaultMessage: 'Created by'
    }),
    width: '15%',
    render: createdBy => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "baseline",
        "data-test-subj": "reportCreatedBy",
        responsive: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 208,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 214,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
        name: createdBy,
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 215,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        className: "eui-textTruncate",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 217,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        className: "eui-textTruncate",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 218,
          columnNumber: 15
        }
      }, createdBy)));
    }
  }, {
    field: 'actions',
    name: _i18n.i18n.translate('xpack.reporting.schedules.tableColumns.actionsTitle', {
      defaultMessage: 'Actions'
    }),
    width: '8%',
    actions: [{
      name: _i18n.i18n.translate('xpack.reporting.schedules.table.editConfig.title', {
        defaultMessage: 'Edit schedule config'
      }),
      description: _i18n.i18n.translate('xpack.reporting.schedules.table.editConfig.description', {
        defaultMessage: 'Edit schedule configuration details'
      }),
      'data-test-subj': item => `reportEditConfig-${item.id}`,
      type: 'icon',
      icon: 'calendar',
      available: item => canManageSchedule(item),
      onClick: item => setReportAndOpenConfigFlyout(item)
    }, {
      name: _i18n.i18n.translate('xpack.reporting.schedules.table.viewConfig.title', {
        defaultMessage: 'View schedule config'
      }),
      description: _i18n.i18n.translate('xpack.reporting.schedules.table.viewConfig.description', {
        defaultMessage: 'View schedule configuration details'
      }),
      'data-test-subj': item => `reportViewConfig-${item.id}`,
      type: 'icon',
      icon: 'calendar',
      available: item => !canManageSchedule(item),
      onClick: item => setReportAndOpenConfigFlyout(item)
    }, {
      name: item => {
        var _item$payload, _item$payload2;
        return _i18n.i18n.translate('xpack.reporting.schedules.table.openDashboard.title', {
          defaultMessage: 'Open in {objectType}',
          values: {
            objectType: (_item$payload = item.payload) !== null && _item$payload !== void 0 && _item$payload.objectType ? (0, _utils.getDisplayNameFromObjectType)((_item$payload2 = item.payload) === null || _item$payload2 === void 0 ? void 0 : _item$payload2.objectType) : 'Kibana'
          }
        });
      },
      description: item => _i18n.i18n.translate('xpack.reporting.schedules.table.openDashboard.description', {
        defaultMessage: 'Open the Kibana app where this report was generated.'
      }),
      'data-test-subj': item => `reportOpenDashboard-${item.id}`,
      type: 'icon',
      icon: 'dashboardApp',
      available: item => {
        var _item$payload3;
        return Boolean((_item$payload3 = item.payload) === null || _item$payload3 === void 0 ? void 0 : _item$payload3.locatorParams);
      },
      onClick: async item => {
        var _item$payload4;
        const searchParams = (0, _queryString.stringify)({
          scheduledReportId: item.id,
          ...queryParams
        });
        const path = (0, _reportingCommon.buildKibanaPath)({
          basePath: http.basePath.serverBasePath,
          spaceId: (_item$payload4 = item.payload) === null || _item$payload4 === void 0 ? void 0 : _item$payload4.spaceId,
          appPath: _reportingCommon.REPORTING_REDIRECT_APP
        });
        const href = `${path}?${searchParams}`;
        window.open(href, '_blank');
        window.focus();
      }
    }, {
      name: _i18n.i18n.translate('xpack.reporting.schedules.table.disableSchedule.title', {
        defaultMessage: 'Disable schedule'
      }),
      description: _i18n.i18n.translate('xpack.reporting.schedules.table.disableSchedule.description', {
        defaultMessage: 'Disable report schedule'
      }),
      'data-test-subj': item => `reportDisableSchedule-${item.id}`,
      available: item => item.enabled && canManageSchedule(item),
      type: 'icon',
      icon: 'cross',
      onClick: item => setReportAndOpenDisableModal(item)
    }, {
      name: _i18n.i18n.translate('xpack.reporting.schedules.table.enableSchedule.title', {
        defaultMessage: 'Enable schedule'
      }),
      description: _i18n.i18n.translate('xpack.reporting.schedules.table.enableSchedule.description', {
        defaultMessage: 'Enable report schedule'
      }),
      'data-test-subj': item => `reportEnableSchedule-${item.id}`,
      available: item => !item.enabled && canManageSchedule(item),
      type: 'icon',
      icon: 'check',
      onClick: item => {
        onEnable(item);
      }
    }, {
      name: _i18n.i18n.translate('xpack.reporting.schedules.table.deleteSchedule.title', {
        defaultMessage: 'Delete schedule'
      }),
      description: _i18n.i18n.translate('xpack.reporting.schedules.table.deleteSchedule.description', {
        defaultMessage: 'Delete report schedule'
      }),
      available: item => canManageSchedule(item),
      'data-test-subj': item => `reportDeleteSchedule-${item.id}`,
      type: 'icon',
      icon: 'trash',
      onClick: item => setReportAndOpenDeleteModal(item)
    }]
  }];
  const setReportAndOpenConfigFlyout = (0, _react.useCallback)(report => {
    setSelectedReport(report);
    setIsConfigFlyOutOpen(true);
  }, [setSelectedReport, setIsConfigFlyOutOpen]);
  const unSetReportAndCloseConfigFlyout = (0, _react.useCallback)(() => {
    setSelectedReport(null);
    setIsConfigFlyOutOpen(false);
  }, [setSelectedReport, setIsConfigFlyOutOpen]);
  const setReportAndOpenDisableModal = (0, _react.useCallback)(report => {
    setSelectedReport(report);
    setIsDisableModalConfirmationOpen(true);
  }, [setSelectedReport, setIsDisableModalConfirmationOpen]);
  const setReportAndOpenDeleteModal = (0, _react.useCallback)(report => {
    setSelectedReport(report);
    setIsDeleteModalConfirmationOpen(true);
  }, [setSelectedReport]);
  const unSetReportAndCloseDisableModal = (0, _react.useCallback)(() => {
    setSelectedReport(null);
    setIsDisableModalConfirmationOpen(false);
  }, [setSelectedReport, setIsDisableModalConfirmationOpen]);
  const unSetReportAndCloseDeleteModal = (0, _react.useCallback)(() => {
    setSelectedReport(null);
    setIsDeleteModalConfirmationOpen(false);
  }, [setSelectedReport, setIsDeleteModalConfirmationOpen]);
  const onDisableConfirm = (0, _react.useCallback)(() => {
    if (selectedReport) {
      bulkDisableScheduledReports({
        ids: [selectedReport.id]
      });
    }
    unSetReportAndCloseDisableModal();
  }, [selectedReport, bulkDisableScheduledReports, unSetReportAndCloseDisableModal]);
  const onDeleteConfirm = (0, _react.useCallback)(() => {
    if (selectedReport) {
      bulkDeleteScheduledReports({
        ids: [selectedReport.id]
      });
    }
    unSetReportAndCloseDeleteModal();
  }, [selectedReport, unSetReportAndCloseDeleteModal, bulkDeleteScheduledReports]);
  const onEnable = (0, _react.useCallback)(item => {
    bulkEnableScheduledReports({
      ids: [item.id]
    });
  }, [bulkEnableScheduledReports]);
  const onCancelDestructiveAction = (0, _react.useCallback)(() => unSetReportAndCloseDisableModal(), [unSetReportAndCloseDisableModal]);
  const tableOnChangeCallback = (0, _react.useCallback)(criteria => {
    const {
      index: page,
      size: perPage
    } = criteria.page;
    setQueryParams(prev => ({
      ...prev,
      page: page + 1,
      perPage
    }));
  }, [setQueryParams]);
  const updateSearch = (0, _react.useCallback)(searchText => {
    setQueryParams(oldParams => ({
      ...oldParams,
      search: searchText,
      page: 1
    }));
  }, []);
  const refresh = (0, _react.useCallback)(() => {
    refreshScheduledReports();
  }, [refreshScheduledReports]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 432,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 433,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    css: (0, _react2.css)`
            ${(0, _eui.logicalCSS)('padding-vertical', euiTheme.size.s)}
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 434,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 440,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "scheduledReportsSearchField",
    fullWidth: true,
    isClearable: true,
    placeholder: _i18n.i18n.translate('xpack.reporting.schedules.table.searchPlaceholderTitle', {
      defaultMessage: 'Search scheduled reports'
    }),
    onSearch: updateSearch,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 441,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 454,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "refreshScheduledReportsButton",
    iconType: "refresh",
    onClick: refresh,
    name: "refresh",
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 455,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.reporting.schedules.table.refreshScheduledReportsButtonLabel",
    defaultMessage: "Refresh",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 462,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 470,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 471,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "reportSchedulesTable",
    items: sortedList,
    columns: tableColumns,
    loading: isLoading,
    pagination: {
      pageIndex: queryParams.page - 1,
      pageSize: queryParams.perPage,
      totalItemCount: (_scheduledList$total = scheduledList === null || scheduledList === void 0 ? void 0 : scheduledList.total) !== null && _scheduledList$total !== void 0 ? _scheduledList$total : 0
    },
    noItemsMessage: _translations.NO_CREATED_REPORTS_DESCRIPTION,
    onChange: tableOnChangeCallback,
    rowProps: () => ({
      'data-test-subj': 'scheduledReportRow'
    }),
    tableCaption: _i18n.i18n.translate('xpack.reporting.schedules.table.reportSchedulesTableCaption', {
      defaultMessage: 'Report schedules table'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 472,
      columnNumber: 9
    }
  })), selectedReport && isConfigFlyOutOpen && (canManageSchedule(selectedReport) ? /*#__PURE__*/_react.default.createElement(_edit_scheduled_report_flyout.EditScheduledReportFlyout, {
    onClose: () => {
      unSetReportAndCloseConfigFlyout();
    },
    scheduledReport: (0, _utils.transformScheduledReport)(selectedReport),
    availableReportTypes: [{
      id: selectedReport.jobtype,
      label: (0, _job_utils.prettyPrintJobType)(selectedReport.jobtype)
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 496,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_view_scheduled_report_flyout.ViewScheduledReportFlyout, {
    onClose: () => {
      unSetReportAndCloseConfigFlyout();
    },
    scheduledReport: (0, _utils.transformScheduledReport)(selectedReport),
    availableReportTypes: [{
      id: selectedReport.jobtype,
      label: (0, _job_utils.prettyPrintJobType)(selectedReport.jobtype)
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 509,
      columnNumber: 11
    }
  })), selectedReport && isDisableModalConfirmationOpen ? /*#__PURE__*/_react.default.createElement(_report_destructive_action_confirmation_modal.ReportDestructiveActionConfirmationModal, {
    title: _i18n.i18n.translate('xpack.reporting.schedules.table.disableSchedule.modalTitle', {
      defaultMessage: 'Disable schedule'
    }),
    message: _i18n.i18n.translate('xpack.reporting.schedules.table.disableSchedule.modalMessage', {
      defaultMessage: 'Disabling this schedule will stop the generation of future exports.'
    }),
    onCancel: onCancelDestructiveAction,
    onConfirm: onDisableConfirm,
    confirmButtonText: _i18n.i18n.translate('xpack.reporting.schedules.table.disableSchedule.modalConfirmButtonText', {
      defaultMessage: 'Disable'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 523,
      columnNumber: 9
    }
  }) : null, selectedReport && isDeleteModalConfirmationOpen ? /*#__PURE__*/_react.default.createElement(_report_destructive_action_confirmation_modal.ReportDestructiveActionConfirmationModal, {
    title: _i18n.i18n.translate('xpack.reporting.schedules.table.deleteSchedule.modalTitle', {
      defaultMessage: 'Delete schedule'
    }),
    message: _i18n.i18n.translate('xpack.reporting.schedules.table.deleteSchedule.modalMessage', {
      defaultMessage: 'Deleting this schedule will stop the generation of future exports. You will not be able to recover this schedule.'
    }),
    onCancel: onCancelDestructiveAction,
    onConfirm: onDeleteConfirm,
    confirmButtonText: _i18n.i18n.translate('xpack.reporting.schedules.table.deleteSchedule.modalConfirmButtonText', {
      defaultMessage: 'Delete'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 541,
      columnNumber: 9
    }
  }) : null);
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.ReportSchedulesTable = ReportSchedulesTable;