"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateScheduleReport = void 0;
var _reportingCommon = require("@kbn/reporting-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateScheduleReport = ({
  http,
  params: {
    reportId,
    title,
    schedule,
    notification
  }
}) => {
  return http.put(`${_reportingCommon.INTERNAL_ROUTES.SCHEDULE_PREFIX}/${reportId}`, {
    body: JSON.stringify({
      title,
      schedule,
      notification
    })
  });
};
exports.updateScheduleReport = updateScheduleReport;