"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openDetailPanel = exports.closeDetailPanel = void 0;
var _shared_imports = require("../../../shared_imports");
var _services = require("../../services");
var _action_types = require("../action_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const openDetailPanel = ({
  name
}) => dispatch => {
  const {
    history
  } = (0, _services.getRouter)();
  const search = history.location.search;
  const {
    cluster: clusterName
  } = (0, _shared_imports.extractQueryParams)(search);
  if (clusterName !== name) {
    // Allow the user to share a deep link to this job.
    history.replace({
      search: `?cluster=${name}`
    });
  }
  dispatch({
    type: _action_types.OPEN_DETAIL_PANEL,
    payload: {
      clusterName: name
    }
  });
};
exports.openDetailPanel = openDetailPanel;
const closeDetailPanel = () => dispatch => {
  dispatch({
    type: _action_types.CLOSE_DETAIL_PANEL
  });
};
exports.closeDetailPanel = closeDetailPanel;