"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReindexServiceServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/core/server");
var _upgradeAssistantPkgServer = require("@kbn/upgrade-assistant-pkg-server");
var _upgradeAssistantPkgCommon = require("@kbn/upgrade-assistant-pkg-common");
var _reindex_service_wrapper = require("./src/lib/reindex_service_wrapper");
var _credential_store = require("./src/lib/credential_store");
var _routes = require("./src/routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line @typescript-eslint/no-empty-interface

class ReindexServiceServerPlugin {
  constructor({
    logger,
    env,
    config
  }) {
    (0, _defineProperty2.default)(this, "reindexService", null);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "version", void 0);
    (0, _defineProperty2.default)(this, "rollupsEnabled", void 0);
    this.logger = logger.get();
    this.version = new _upgradeAssistantPkgCommon.Version();
    this.version.setup(env.packageInfo.version);
    this.rollupsEnabled = config.get().rollupsEnabled;
  }
  setup({
    http,
    savedObjects,
    getStartServices
  }) {
    const dependencies = {
      router: http.createRouter(),
      getReindexService: async () => {
        const [,, reindexService] = await getStartServices();
        return reindexService;
      }
    };
    savedObjects.registerType(_upgradeAssistantPkgServer.reindexOperationSavedObjectType);
    (0, _routes.registerReindexIndicesRoutes)(dependencies);
    (0, _routes.registerBatchReindexIndicesRoutes)(dependencies);
  }
  start({
    savedObjects,
    elasticsearch
  }, {
    security,
    licensing
  }) {
    const soClient = new _server.SavedObjectsClient(savedObjects.createInternalRepository([_upgradeAssistantPkgServer.reindexOperationSavedObjectType.name]));

    // The ReindexWorker uses a map of request headers that contain the authentication credentials
    // for a given reindex. We cannot currently store these in an the .kibana index b/c we do not
    // want to expose these credentials to any unauthenticated users. We also want to avoid any need
    // to add a user for a special index just for upgrading. This in-memory cache allows us to
    // process jobs without the browser staying on the page, but will require that jobs go into
    // a paused state if no Kibana nodes have the required credentials.

    // The ReindexWorker will use the credentials stored in the cache to reindex the data

    const service = new _reindex_service_wrapper.ReindexServiceWrapper({
      soClient,
      credentialStore: (0, _credential_store.credentialStoreFactory)(this.logger),
      clusterClient: elasticsearch.client,
      logger: this.logger,
      licensing,
      security,
      version: this.version,
      rollupsEnabled: this.rollupsEnabled
    });
    this.reindexService = service.getInternalApis();
    return {
      cleanupReindexOperations: service.cleanupReindexOperations.bind(service),
      getScopedClient: service.getScopedClient.bind(service)
    };
  }
  stop() {
    var _this$reindexService;
    (_this$reindexService = this.reindexService) === null || _this$reindexService === void 0 ? void 0 : _this$reindexService.stop();
  }
}
exports.ReindexServiceServerPlugin = ReindexServiceServerPlugin;