"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDataTabs = void 0;
exports.AddDataView = AddDataView;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _major = _interopRequireDefault(require("semver/functions/major"));
var _use_profiling_params = require("../../hooks/use_profiling_params");
var _use_profiling_router = require("../../hooks/use_profiling_router");
var _use_profiling_route_path = require("../../hooks/use_profiling_route_path");
var _use_async = require("../../hooks/use_async");
var _use_profiling_dependencies = require("../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _profiling_app_page_template = require("../../components/profiling_app_page_template");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/views/add_data_view/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let AddDataTabs = exports.AddDataTabs = /*#__PURE__*/function (AddDataTabs) {
  AddDataTabs["Kubernetes"] = "kubernetes";
  AddDataTabs["Docker"] = "docker";
  AddDataTabs["Binary"] = "binary";
  AddDataTabs["Deb"] = "deb";
  AddDataTabs["RPM"] = "rpm";
  AddDataTabs["ElasticAgentIntegration"] = "elasticAgentIntegration";
  AddDataTabs["Symbols"] = "symbols";
  return AddDataTabs;
}({});
const supportedCPUArchitectures = ['x86_64', 'arm64'];
function AddDataView() {
  var _data$collector, _data$collector2, _data$symbolizer, _displayedTab$subTabs, _displayedTab$subTabs2;
  const {
    query
  } = (0, _use_profiling_params.useProfilingParams)('/add-data-instructions');
  const {
    selectedTab
  } = query;
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  const routePath = (0, _use_profiling_route_path.useProfilingRoutePath)();
  const [selectedSubTabKey, setSelectedSubTabKey] = (0, _react.useState)();
  const {
    services: {
      setupDataCollectionInstructions
    },
    start: {
      core
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const {
    docLinks
  } = core;
  const {
    data,
    status
  } = (0, _use_async.useAsync)(({
    http
  }) => {
    return setupDataCollectionInstructions({
      http
    });
  }, [setupDataCollectionInstructions]);
  const secretToken = data === null || data === void 0 ? void 0 : (_data$collector = data.collector) === null || _data$collector === void 0 ? void 0 : _data$collector.secretToken;
  const collectionAgentHost = data === null || data === void 0 ? void 0 : (_data$collector2 = data.collector) === null || _data$collector2 === void 0 ? void 0 : _data$collector2.host;
  const symbolUrl = data === null || data === void 0 ? void 0 : (_data$symbolizer = data.symbolizer) === null || _data$symbolizer === void 0 ? void 0 : _data$symbolizer.host;
  const stackVersion = data === null || data === void 0 ? void 0 : data.stackVersion;
  const majorVersion = stackVersion ? (0, _major.default)(stackVersion).toString() : undefined;
  const tabs = (0, _react.useMemo)(() => [{
    key: AddDataTabs.Kubernetes,
    title: _i18n.i18n.translate('xpack.profiling.tabs.kubernetesTitle', {
      defaultMessage: 'Kubernetes'
    }),
    steps: [{
      title: _i18n.i18n.translate('xpack.profiling.tabs.kubernetesRepositoryStep', {
        defaultMessage: 'Configure the Universal Profiling Agent Helm repository:'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.profiling.tabs.helmRepoAddElasticCodeBlockLabel', {
        defaultMessage: 'helm repo add elastic https://helm.elastic.co'
      }))
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.kubernetesInstallStep', {
        defaultMessage: 'Install host-agent via Helm:'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 15
        }
      }, `helm install --create-namespace -n=universal-profiling universal-profiling-agent \\
--set "projectID=1,secretToken=${secretToken}" \\
--set "collectionAgentHostPort=${collectionAgentHost}" \\
--version=${stackVersion} \\
elastic/profiling-agent`)
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.kubernetesValidationStep', {
        defaultMessage: 'Validate the host-agent pods are running:'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.profiling.tabs.kubectlGetPods', {
        defaultMessage: 'kubectl -n universal-profiling get pods'
      }))
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.postValidationStep', {
        defaultMessage: 'Use the Helm install output to get host-agent logs and spot potential errors'
      }),
      content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)
    }]
  }, {
    key: AddDataTabs.Docker,
    title: _i18n.i18n.translate('xpack.profiling.tabs.dockerTitle', {
      defaultMessage: 'Docker'
    }),
    steps: [{
      title: _i18n.i18n.translate('xpack.profiling.tabs.dockerRunContainerStep', {
        defaultMessage: 'Run the Universal Profiling container:'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 152,
          columnNumber: 15
        }
      }, `docker run --name pf-host-agent --privileged --pid=host -v /etc/machine-id:/etc/machine-id:ro \\
-v /var/run/docker.sock:/var/run/docker.sock -v /sys/kernel/debug:/sys/kernel/debug:ro \\
docker.elastic.co/observability/profiling-agent:${stackVersion} /root/pf-host-agent \\
-project-id=1 -secret-token=${secretToken} \\
-collection-agent=${collectionAgentHost}`)
    }]
  }, {
    key: AddDataTabs.Binary,
    title: _i18n.i18n.translate('xpack.profiling.tabs.binaryTitle', {
      defaultMessage: 'Binary'
    }),
    // Create a dedicated sub tab for each architecture that we support
    subTabs: supportedCPUArchitectures.map(arch => {
      return {
        key: arch,
        title: `Linux ${arch}`,
        steps: [{
          title: _i18n.i18n.translate('xpack.profiling.tabs.binaryDownloadStep', {
            defaultMessage: 'Download the binary:'
          }),
          content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
            paddingSize: "s",
            isCopyable: true,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 179,
              columnNumber: 19
            }
          }, `wget -O pf-host-agent.tgz "https://artifacts.elastic.co/downloads/prodfiler/pf-host-agent-${stackVersion}-linux-${arch}.tar.gz" && tar xzf pf-host-agent.tgz`)
        }, {
          title: _i18n.i18n.translate('xpack.profiling.tabs.binaryGrantPermissionStep', {
            defaultMessage: 'Grant executable permissions:'
          }),
          content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
            paddingSize: "s",
            isCopyable: true,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 189,
              columnNumber: 19
            }
          }, `chmod +x pf-host-agent-${stackVersion}-linux-${arch}/pf-host-agent`)
        }, {
          title: _i18n.i18n.translate('xpack.profiling.tabs.binaryRunHostAgentStep', {
            defaultMessage: 'Run the Universal Profiling host-agent (requires root privileges):'
          }),
          content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
            paddingSize: "s",
            isCopyable: true,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 200,
              columnNumber: 19
            }
          }, `sudo pf-host-agent-${stackVersion}-linux-${arch}/pf-host-agent -project-id=1 -secret-token=${secretToken} -collection-agent=${collectionAgentHost}`)
        }]
      };
    })
  }, {
    key: AddDataTabs.Deb,
    title: _i18n.i18n.translate('xpack.profiling.tabs.debTitle', {
      defaultMessage: 'DEB Package'
    }),
    steps: [{
      title: _i18n.i18n.translate('xpack.profiling.tabs.debConfigureRepoStep', {
        defaultMessage: 'Configure the apt repository (requires root privileges):'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 220,
          columnNumber: 15
        }
      }, `wget -qO - https://artifacts.elastic.co/GPG-KEY-elasticsearch | sudo apt-key add -
      sudo apt-get install apt-transport-https
      echo "deb https://artifacts.elastic.co/packages/${majorVersion}.x/apt stable main" | sudo tee -a /etc/apt/sources.list.d/elastic-${majorVersion}.x.list
      `)
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.debInstallPackageStep', {
        defaultMessage: 'Install the DEB package (requires root privileges):'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 233,
          columnNumber: 15
        }
      }, `sudo apt-get update && sudo apt-get install pf-host-agent`)
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.debEditConfigStep', {
        defaultMessage: 'Edit the configuration (requires root privileges):'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 243,
          columnNumber: 15
        }
      }, `echo -e "project-id 1\nsecret-token ${secretToken}\ncollection-agent ${collectionAgentHost}" | sudo tee -a /etc/Elastic/universal-profiling/pf-host-agent.conf`)
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.debStartSystemdServiceStep', {
        defaultMessage: 'Start the Universal Profiling systemd service (requires root privileges):'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 254,
          columnNumber: 15
        }
      }, `sudo systemctl enable pf-host-agent && sudo systemctl restart pf-host-agent`)
    }]
  }, {
    key: AddDataTabs.RPM,
    title: _i18n.i18n.translate('xpack.profiling.tabs.rpmTitle', {
      defaultMessage: 'RPM Package'
    }),
    steps: [{
      title: _i18n.i18n.translate('xpack.profiling.tabs.rpmConfigureRepoStep', {
        defaultMessage: 'Configure the yum repository (requires root privileges):'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 272,
          columnNumber: 15
        }
      }, `sudo rpm --import https://packages.elastic.co/GPG-KEY-elasticsearch
      cat <<EOF > /etc/yum.repos.d/elastic.repo
[elastic-${majorVersion}.x]
name=Elastic repository for ${majorVersion}.x packages
baseurl=https://artifacts.elastic.co/packages/${majorVersion}.x/yum
gpgcheck=1
gpgkey=https://artifacts.elastic.co/GPG-KEY-elasticsearch
enabled=1
autorefresh=1
type=rpm-md
EOF`)
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.rpmInstallPackageStep', {
        defaultMessage: 'Install the RPM package (requires root privileges):'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 292,
          columnNumber: 15
        }
      }, `sudo yum install pf-host-agent`)
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.rpmEditConfigStep', {
        defaultMessage: 'Edit the configuration (requires root privileges):'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 302,
          columnNumber: 15
        }
      }, `echo -e "project-id 1\nsecret-token ${secretToken}\ncollection-agent ${collectionAgentHost}" | sudo tee -a /etc/Elastic/universal-profiling/pf-host-agent.conf`)
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.rpmStartSystemdServiceStep', {
        defaultMessage: 'Start the Universal Profiling systemd service (requires root privileges):'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 313,
          columnNumber: 15
        }
      }, `sudo systemctl enable pf-host-agent && sudo systemctl restart pf-host-agent`)
    }]
  }, {
    key: AddDataTabs.ElasticAgentIntegration,
    title: _i18n.i18n.translate('xpack.profiling.tabs.elasticAgentIntegration.title', {
      defaultMessage: 'Elastic Agent Integration'
    }),
    steps: [{
      title: _i18n.i18n.translate('xpack.profiling.tabs.elasticAgentIntegration.step1', {
        defaultMessage: 'Copy credentials'
      }),
      content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 332,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.profiling.tabs.elasticAgentIntegration.step1.hint', {
        defaultMessage: "You'll need these credentials to set up Universal Profiling. Please save them in a secure location, as they will be required in the subsequent step."
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 338,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        style: {
          fontWeight: 'bold'
        },
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 339,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.profiling.tabs.elasticAgentIntegration.step1.secretToken', {
        defaultMessage: 'Secret token:'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 347,
          columnNumber: 17
        }
      }, secretToken), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 350,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        style: {
          fontWeight: 'bold'
        },
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 351,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.profiling.tabs.elasticAgentIntegration.step1.collectionAgentUrl', {
        defaultMessage: 'Universal Profiling Collector URL:'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 357,
          columnNumber: 17
        }
      }, collectionAgentHost))
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.elasticAgentIntegration.step2', {
        defaultMessage: 'Fleet'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "profilingAddDataViewManageUniversalProfilingAgentInFleetButton",
        iconType: "gear",
        fill: true,
        href: `${core.http.basePath.prepend(`/app/integrations/detail/profiler_agent-${data === null || data === void 0 ? void 0 : data.profilerAgent.version}/overview`)}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 368,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.profiling.tabs.elasticAgentIntegration.step2.button', {
        defaultMessage: 'Manage Universal Profiling agent in Fleet'
      }))
    }]
  }, {
    key: AddDataTabs.Symbols,
    title: _i18n.i18n.translate('xpack.profiling.tabs.symbols.title', {
      defaultMessage: 'Upload Symbols'
    }),
    subTabs: supportedCPUArchitectures.map(arch => {
      return {
        key: arch,
        title: `Linux ${arch}`,
        // inside each sub tab you define the steps as usual
        steps: [{
          title: _i18n.i18n.translate('xpack.profiling.tabs.symbols.step1', {
            defaultMessage: 'Download and extract symbtool'
          }),
          content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
            paddingSize: "s",
            isCopyable: true,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 400,
              columnNumber: 19
            }
          }, `wget -O symbtool-${arch}.tgz "https://artifacts.elastic.co/downloads/prodfiler/symbtool-${stackVersion}-linux-${arch}.tar.gz" && tar xzf symbtool-${arch}.tgz && cd symbtool-${stackVersion}-linux-${arch}`)
        }, {
          title: _i18n.i18n.translate('xpack.profiling.tabs.symbols.step2', {
            defaultMessage: 'Generate an Elasticsearch token'
          }),
          content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 410,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "profilingAddDataViewInstructionsHereLink",
            target: "_blank",
            href: docLinks.links.management.apiKeys,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 411,
              columnNumber: 21
            }
          }, _i18n.i18n.translate('xpack.profiling.tabs.symbols.step2.instructions', {
            defaultMessage: 'Instructions here'
          })))
        }, {
          title: _i18n.i18n.translate('xpack.profiling.tabs.symbols.step3', {
            defaultMessage: 'Upload symbols'
          }),
          content: /*#__PURE__*/_react.default.createElement("div", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 428,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
            paddingSize: "s",
            isCopyable: true,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 429,
              columnNumber: 21
            }
          }, `./symbtool push-symbols executable -u "${symbolUrl}" -t <ES token> -e <my executable>`), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
            size: "m",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 432,
              columnNumber: 21
            }
          }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 433,
              columnNumber: 21
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.profiling.tabs.symbols.step3.replace",
            defaultMessage: "Replace {es_token} etc. with the actual values. You can pass {help} to obtain a list of other arguments.",
            values: {
              es_token: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 438,
                  columnNumber: 37
                }
              }, `<ES token>`),
              help: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 440,
                  columnNumber: 29
                }
              }, _i18n.i18n.translate('xpack.profiling.tabs.symbols.helpFlag', {
                defaultMessage: '--help'
              }))
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 434,
              columnNumber: 23
            }
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
            size: "s",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 449,
              columnNumber: 21
            }
          }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 450,
              columnNumber: 21
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.profiling.tabs.symbols.step3.doc-ref",
            defaultMessage: "Documentation for more advanced uses cases is available in {link}.",
            values: {
              link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
                "data-test-subj": "profilingAddDataViewTheCorrespondingDocumentationPageLink",
                target: "_blank",
                href: `${docLinks.ELASTIC_WEBSITE_URL}/guide/en/observability/${docLinks.DOC_LINK_VERSION}/profiling-add-symbols.html`,
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 456,
                  columnNumber: 29
                }
              }, _i18n.i18n.translate('xpack.profiling.tabs.symbols.step3.doc-ref.link', {
                defaultMessage: 'the corresponding documentation page'
              }))
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 451,
              columnNumber: 23
            }
          })))
        }]
      };
    })
  }], [collectionAgentHost, docLinks.DOC_LINK_VERSION, docLinks.ELASTIC_WEBSITE_URL, docLinks.links.management.apiKeys, core.http.basePath, data === null || data === void 0 ? void 0 : data.profilerAgent.version, majorVersion, secretToken, stackVersion, symbolUrl]);
  const displayedTab = (0, _react.useMemo)(() => tabs.find(tab => tab.key === selectedTab), [selectedTab, tabs]);
  (0, _react.useEffect)(() => {
    if (displayedTab.subTabs) {
      const firstTabKey = displayedTab.subTabs[0].key;
      setSelectedSubTabKey(firstTabKey);
    }
  }, [displayedTab]);
  const selectedSubTab = selectedSubTabKey ? (_displayedTab$subTabs = displayedTab.subTabs) === null || _displayedTab$subTabs === void 0 ? void 0 : _displayedTab$subTabs.find(tab => tab.key === selectedSubTabKey) : undefined;
  const displayedSteps = displayedTab.steps || (selectedSubTab === null || selectedSubTab === void 0 ? void 0 : selectedSubTab.steps) || [];
  const subTabs = (_displayedTab$subTabs2 = displayedTab.subTabs) !== null && _displayedTab$subTabs2 !== void 0 ? _displayedTab$subTabs2 : [];
  const isLoading = status === _use_async.AsyncStatus.Loading;
  return /*#__PURE__*/_react.default.createElement(_profiling_app_page_template.ProfilingAppPageTemplate, {
    tabs: [],
    restrictWidth: true,
    hideSearchBar: true,
    pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 518,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 519,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoObservability",
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 520,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 522,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.profiling.noDataPage.pageTitle', {
      defaultMessage: 'Add profiling data'
    })), isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 528,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 529,
        columnNumber: 15
      }
    })) : null),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 513,
      columnNumber: 5
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "warning",
    iconType: "question",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.profiling.tabs.debWarning",
      defaultMessage: "Due to a {linuxLink} bug which impacts stability, the Universal Profiling agent will not run on unpatched kernel versions {versionFrom} to {versionTo}. Refer to {debianLink} and {fedoraLink} to learn more. If you are running an affected kernel, the Universal Profiling agent dynamically checks for the patch. Refer to {advancedLink} for instructions on overriding this check.",
      values: {
        versionFrom: /*#__PURE__*/_react.default.createElement("strong", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 549,
            columnNumber: 21
          }
        }, _i18n.i18n.translate('xpack.profiling.tabs.strong.5.19Label', {
          defaultMessage: '5.19'
        })),
        versionTo: /*#__PURE__*/_react.default.createElement("strong", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 556,
            columnNumber: 21
          }
        }, _i18n.i18n.translate('xpack.profiling.tabs.strong.6.4Label', {
          defaultMessage: '6.4'
        })),
        linuxLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "profilingAddDataViewLinuxKernelBugLink",
          target: "_blank",
          href: "https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=d319f344561de23e810515d109c7278919bff7b0",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 563,
            columnNumber: 21
          }
        }, _i18n.i18n.translate('xpack.profiling.tabs.debWarning.linuxLink', {
          defaultMessage: 'Linux kernel bug'
        })),
        debianLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "profilingAddDataViewDebianLink",
          target: "_blank",
          href: "https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=1033398",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 574,
            columnNumber: 21
          }
        }, _i18n.i18n.translate('xpack.profiling.tabs.debWarning.debianLink', {
          defaultMessage: 'Debian'
        })),
        fedoraLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "profilingAddDataViewFedoraCentOsLink",
          target: "_blank",
          href: "https://bugzilla.redhat.com/show_bug.cgi?id=2211455",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 585,
            columnNumber: 21
          }
        }, _i18n.i18n.translate('xpack.profiling.tabs.debWarning.fedoraLink', {
          defaultMessage: 'Fedora/CentOS'
        })),
        advancedLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "profilingAddDataViewAdvancedConfigurationLink",
          target: "_blank",
          href: `${docLinks.ELASTIC_WEBSITE_URL}/guide/en/observability/${docLinks.DOC_LINK_VERSION}/profiling-advanced-configuration.html`,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 596,
            columnNumber: 21
          }
        }, _i18n.i18n.translate('xpack.profiling.tabs.debWarning.advancedLink', {
          defaultMessage: 'Advanced configuration'
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 544,
        columnNumber: 15
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 539,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 610,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 611,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.profiling.noDataPage.addDataTitle', {
    defaultMessage: 'Select an option below to deploy the Universal Profiling Agent.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 616,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 617,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    grow: false,
    paddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 618,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued",
    paddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 619,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    style: {
      padding: '0 24px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 620,
      columnNumber: 17
    }
  }, tabs.map(tab => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      key: tab.key,
      onClick: () => {
        profilingRouter.push(routePath, {
          path: {},
          query: {
            selectedTab: tab.key
          }
        });
      },
      isSelected: tab.key === selectedTab,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 623,
        columnNumber: 23
      }
    }, tab.title);
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    style: {
      padding: '0 24px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 639,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 640,
      columnNumber: 17
    }
  }), subTabs.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    style: {
      padding: '0 24px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 642,
      columnNumber: 19
    }
  }, subTabs.map(tab => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      key: tab.key,
      onClick: () => {
        setSelectedSubTabKey(tab.key);
      },
      isSelected: tab.key === selectedSubTabKey,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 645,
        columnNumber: 25
      }
    }, tab.title);
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 658,
      columnNumber: 17
    }
  }), displayedSteps.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: displayedSteps.map(step => {
      return {
        title: step.title,
        children: step.content,
        status: 'incomplete'
      };
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 660,
      columnNumber: 19
    }
  }))))));
}