"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DifferentialTopNFunctionsGrid = DifferentialTopNFunctionsGrid;
exports.getFrameIdentification = getFrameIdentification;
exports.isComparisonColumn = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _profilingUtils = require("@kbn/profiling-utils");
var _lodash = require("lodash");
var _react2 = _interopRequireWildcard(require("react"));
var _use_calculate_impact_estimates = require("../../hooks/use_calculate_impact_estimates");
var _frame_information_tooltip = require("../frame_information_window/frame_information_tooltip");
var _search_functions_input = require("../search_functions_input");
var _function_row = require("../topn_functions/function_row");
var _utils = require("../topn_functions/utils");
var _get_columns = require("./get_columns");
var _get_compare_frame_action = require("./get_compare_frame_action");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/differential_topn_functions_grid/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const removeComparisonFromId = id => id.replace('comparison_', '');
const isComparisonColumn = id => id.startsWith('comparison_');
exports.isComparisonColumn = isComparisonColumn;
function sortRows(data, sortField, sortDirection) {
  switch (sortField) {
    case _profilingUtils.TopNFunctionSortField.Frame:
      return (0, _lodash.orderBy)(data, row => (0, _profilingUtils.getCalleeFunction)(row.frame), sortDirection);
    case _profilingUtils.TopNFunctionSortField.SelfCPU:
      return (0, _lodash.orderBy)(data, row => row.selfCPUPerc, sortDirection);
    case _profilingUtils.TopNFunctionSortField.TotalCPU:
      return (0, _lodash.orderBy)(data, row => row.totalCPUPerc, sortDirection);
    default:
      return (0, _lodash.orderBy)(data, sortField, sortDirection);
  }
}
function getFrameIdentification(frame) {
  return [frame.SourceFilename, frame.FunctionName, frame.ExeFileName, frame.FileID, frame.AddressOrLine].join('|');
}
function DifferentialTopNFunctionsGrid({
  base,
  baselineScaleFactor,
  comparison,
  comparisonScaleFactor,
  comparisonSortDirection,
  comparisonSortField,
  comparisonTotalSeconds,
  onChangePage,
  onChangeSort,
  onFrameClick,
  pageIndex,
  sortDirection,
  sortField,
  totalSeconds,
  searchFunctionName,
  onSearchFunctionNameChange
}) {
  var _rowsInformation$comp;
  const theme = (0, _eui.useEuiTheme)();
  const calculateImpactEstimates = (0, _use_calculate_impact_estimates.useCalculateImpactEstimate)();
  const [selectedFrame, setSelectedFrame] = (0, _react2.useState)();
  const [rowsInformation, setRowsInformation] = (0, _react2.useState)();
  const {
    totalCount,
    comparisonTotalCount
  } = (0, _react2.useMemo)(() => {
    return {
      totalCount: (0, _utils.getTotalCount)(base),
      comparisonTotalCount: (0, _utils.getTotalCount)(comparison)
    };
  }, [base, comparison]);
  function onSort(newSortingColumns) {
    // As newSortingColumns is an array and we only sort by a single field for both base and comparison
    // I need to look for the item that is not the same as in the URL to identify what's the side being sorted.
    const sortingItem = newSortingColumns.reverse().find(item => {
      const isComparison = isComparisonColumn(item.id);
      if (isComparison) {
        return !(comparisonSortField === item.id && comparisonSortDirection === item.direction);
      }
      return !(sortField === item.id && sortDirection === item.direction);
    });
    if (sortingItem) {
      const isComparison = isComparisonColumn(sortingItem.id);
      onChangeSort(isComparison ? {
        comparisonSortDirection: sortingItem.direction,
        comparisonSortField: sortingItem.id
      } : {
        sortDirection: sortingItem.direction,
        sortField: sortingItem.id
      });
    }
  }
  const {
    baseRows,
    comparisonRows
  } = (0, _react2.useMemo)(() => {
    return {
      baseRows: (0, _utils.getFunctionsRows)({
        calculateImpactEstimates,
        topNFunctions: base,
        totalSeconds,
        functionNameSearchQuery: searchFunctionName
      }),
      comparisonRows: (0, _utils.getFunctionsRows)({
        baselineScaleFactor,
        calculateImpactEstimates,
        comparisonScaleFactor,
        comparisonTopNFunctions: base,
        topNFunctions: comparison,
        totalSeconds: comparisonTotalSeconds,
        functionNameSearchQuery: searchFunctionName
      })
    };
  }, [base, baselineScaleFactor, calculateImpactEstimates, comparison, comparisonScaleFactor, comparisonTotalSeconds, searchFunctionName, totalSeconds]);
  const columns = (0, _react2.useMemo)(() => {
    const compareFrameAction = (0, _get_compare_frame_action.getCompareFrameAction)({
      baseRows,
      comparisonRows,
      onClick: setSelectedFrame,
      selectedFrame
    });
    return (0, _get_columns.getColumns)(compareFrameAction);
  }, [baseRows, comparisonRows, selectedFrame]);
  const sortedBaseRows = (0, _react2.useMemo)(() => {
    return sortRows(baseRows, sortField, sortDirection);
  }, [baseRows, sortDirection, sortField]);
  const sortedComparisonRows = (0, _react2.useMemo)(() => {
    return sortRows(comparisonRows, removeComparisonFromId(comparisonSortField), comparisonSortDirection);
  }, [comparisonRows, comparisonSortDirection, comparisonSortField]);
  const [visibleColumns, setVisibleColumns] = (0, _react2.useState)(columns.map(({
    id
  }) => id));
  function CellValue({
    rowIndex,
    columnId,
    setCellProps
  }) {
    const isComparison = isComparisonColumn(columnId);
    const data = isComparison ? sortedComparisonRows[rowIndex] : sortedBaseRows[rowIndex];
    (0, _react2.useEffect)(() => {
      // Add thick border to divide the baseline and comparison columns
      if (isComparison && columnId === _profilingUtils.TopNComparisonFunctionSortField.ComparisonRank) {
        setCellProps({
          style: {
            borderLeft: theme.euiTheme.border.thick
          }
        });
      } else if (columnId === _profilingUtils.TopNFunctionSortField.TotalCPU) {
        setCellProps({
          style: {
            borderRight: theme.euiTheme.border.thin
          }
        });
      }
    }, [columnId, isComparison, setCellProps]);
    if (data === undefined) {
      return null;
    }
    return /*#__PURE__*/_react2.default.createElement("div", {
      "data-test-subj": columnId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_function_row.FunctionRow, {
      functionRow: data,
      columnId: removeComparisonFromId(columnId),
      setCellProps: setCellProps,
      totalCount: totalCount,
      onFrameClick: onFrameClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 9
      }
    }));
  }
  const rowCount = Math.max(sortedBaseRows.length, sortedComparisonRows.length);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_search_functions_input.SearchFunctionsInput, {
    onChange: onSearchFunctionNameChange,
    value: searchFunctionName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiDataGrid, {
    "data-test-subj": "profilingDiffTopNFunctionsGrid",
    css: (0, _react.css)`
            .thickBorderLeft {
              border-left: ${theme.euiTheme.border.thick};
            }
          `,
    "aria-label": _i18n.i18n.translate('xpack.profiling.onWeelkDiffTopN.euiDataGrid.topNFunctionsLabel', {
      defaultMessage: 'TopN functions'
    }),
    columns: columns,
    leadingControlColumns: [{
      id: 'actions',
      width: 40,
      headerCellRender() {
        return /*#__PURE__*/_react2.default.createElement(_eui.EuiScreenReaderOnly, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 269,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react2.default.createElement("span", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 270,
            columnNumber: 21
          }
        }, _i18n.i18n.translate('xpack.profiling.topNFunctionsGrid.span.controlsLabel', {
          defaultMessage: 'Controls'
        })));
      },
      rowCellRender: function RowCellRender({
        rowIndex
      }) {
        function handleOnClick() {
          const row = sortedBaseRows[rowIndex];
          const currentFrameId = getFrameIdentification(row.frame);
          const compareRow = sortedComparisonRows.find(item => getFrameIdentification(item.frame) === currentFrameId);
          setRowsInformation({
            baseRow: row,
            comparisonRow: compareRow
          });
        }
        return /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
          "data-test-subj": "profilingTopNFunctionsGridButton",
          "aria-label": _i18n.i18n.translate('xpack.profiling.topNFunctionsGrid.euiButtonIcon.showActionsLabel', {
            defaultMessage: 'Show actions'
          }),
          iconType: "expand",
          color: "text",
          onClick: handleOnClick,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 291,
            columnNumber: 19
          }
        });
      }
    }],
    columnVisibility: {
      visibleColumns,
      setVisibleColumns
    },
    rowCount: rowCount,
    renderCellValue: CellValue,
    sorting: {
      columns: [{
        id: sortField,
        direction: sortDirection
      }, {
        id: comparisonSortField,
        direction: comparisonSortDirection
      }],
      onSort
    },
    pagination: {
      pageIndex,
      pageSize: 100,
      // Left it empty on purpose as it is a required property on the pagination
      onChangeItemsPerPage: () => {},
      onChangePage,
      pageSizeOptions: []
    },
    rowHeightsOptions: {
      defaultHeight: 'auto'
    },
    toolbarVisibility: {
      showColumnSelector: false,
      showKeyboardShortcuts: false,
      showDisplaySelector: false,
      showSortSelector: false
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 9
    }
  }), rowsInformation && /*#__PURE__*/_react2.default.createElement(_frame_information_tooltip.FrameInformationTooltip, {
    compressed: true,
    comparisonRank: (_rowsInformation$comp = rowsInformation.comparisonRow) === null || _rowsInformation$comp === void 0 ? void 0 : _rowsInformation$comp.rank,
    comparisonFrame: rowsInformation.comparisonRow ? (0, _utils.convertRowToFrame)(rowsInformation.comparisonRow) : undefined,
    comparisonTotalSamples: comparisonTotalCount,
    comparisonTotalSeconds: comparisonTotalSeconds,
    rank: rowsInformation.baseRow.rank,
    frame: (0, _utils.convertRowToFrame)(rowsInformation.baseRow),
    totalSamples: totalCount,
    totalSeconds: totalSeconds,
    onClose: () => {
      setRowsInformation(undefined);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 11
    }
  })));
}