"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGetStatusService = createGetStatusService;
var _cloud_setup = require("../../../common/cloud_setup");
var _setup = require("../../../common/setup");
var _setup_state = require("../setup_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createGetStatusService(params) {
  return async ({
    esClient,
    soClient,
    spaceId
  }) => {
    try {
      const {
        type,
        setupState
      } = await (0, _setup_state.getSetupState)({
        ...params,
        esClient,
        soClient,
        spaceId
      });
      params.logger.debug(() => `Set up state for: ${type}: ${JSON.stringify(setupState, null, 2)}`);
      return {
        has_setup: type === 'cloud' ? (0, _cloud_setup.areCloudResourcesSetup)(setupState) : (0, _setup.areResourcesSetup)(setupState),
        has_data: setupState.data.available,
        pre_8_9_1_data: setupState.resources.pre_8_9_1_data
      };
    } catch (error) {
      var _error$meta, _error$originalError, _error$originalError$;
      // We cannot fully check the status of all resources
      // to make sure Profiling has been set up and has data
      // for users with monitor privileges. This privileges
      // is needed to call the profiling ES plugin for example.
      if ((error === null || error === void 0 ? void 0 : (_error$meta = error.meta) === null || _error$meta === void 0 ? void 0 : _error$meta.statusCode) === 403 || (error === null || error === void 0 ? void 0 : (_error$originalError = error.originalError) === null || _error$originalError === void 0 ? void 0 : (_error$originalError$ = _error$originalError.meta) === null || _error$originalError$ === void 0 ? void 0 : _error$originalError$.statusCode) === 403) {
        return {
          has_setup: true,
          pre_8_9_1_data: false,
          has_data: true,
          unauthorized: true
        };
      }
      throw error;
    }
  };
}