"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cloudSetupState = cloudSetupState;
var _cloud_setup = require("../../../common/cloud_setup");
var _cluster_settings = require("../../../common/cluster_settings");
var _fleet_policies = require("../../../common/fleet_policies");
var _has_profiling_data = require("../../../common/has_profiling_data");
var _setup = require("../../../common/setup");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function cloudSetupState(params) {
  const state = (0, _cloud_setup.createDefaultCloudSetupState)();
  state.cloud.available = params.isCloudEnabled;
  const verifyFunctions = [_cluster_settings.validateMaximumBuckets, _cluster_settings.validateResourceManagement, _fleet_policies.validateCollectorPackagePolicy, _fleet_policies.validateSymbolizerPackagePolicy, _fleet_policies.validateProfilingInApmPackagePolicy, _has_profiling_data.hasProfilingData];
  const partialStates = await Promise.all(verifyFunctions.map(fn => fn(params)));
  return (0, _setup.mergePartialSetupStates)(state, partialStates);
}