"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.overrideInferenceSettings = exports.createIndex = void 0;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createIndex = async ({
  esClient,
  indexName,
  manifestVersion,
  mappings,
  log
}) => {
  log.debug(`Creating index ${indexName}`);
  const legacySemanticText = (0, _utils.isLegacySemanticTextVersion)(manifestVersion);
  await esClient.indices.create({
    index: indexName,
    mappings,
    settings: {
      number_of_shards: 1,
      auto_expand_replicas: '0-1',
      'index.mapping.semantic_text.use_legacy_format': legacySemanticText
    }
  });
};
exports.createIndex = createIndex;
const overrideInferenceSettings = (mappings, inferenceId, modelSettingsToOverride) => {
  const recursiveOverride = current => {
    if ((0, _mlIsPopulatedObject.isPopulatedObject)(current, ['type']) && current.type === 'semantic_text') {
      current.inference_id = inferenceId;
      if (modelSettingsToOverride) {
        // @ts-expect-error - model_settings is not typed, but exists for semantic_text field
        current.model_settings = modelSettingsToOverride;
      }
    }
    if ((0, _mlIsPopulatedObject.isPopulatedObject)(current, ['properties'])) {
      for (const prop of Object.values(current.properties)) {
        recursiveOverride(prop);
      }
    }
  };
  recursiveOverride(mappings);
};
exports.overrideInferenceSettings = overrideInferenceSettings;