"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = void 0;
var _configSchema = require("@kbn/config-schema");
var _consts = require("../common/consts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const configSchema = _configSchema.schema.object({
  artifactRepositoryUrl: _configSchema.schema.string({
    defaultValue: 'https://kibana-knowledge-base-artifacts.elastic.co'
  }),
  elserInferenceId: _configSchema.schema.string({
    defaultValue: _consts.internalElserInferenceId
  })
});
const config = exports.config = {
  schema: configSchema,
  exposeToBrowser: {}
};