"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallationService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _inferenceCommon = require("@kbn/inference-common");
var _installation = require("../../../common/http_api/installation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InstallationService {
  constructor({
    http
  }) {
    (0, _defineProperty2.default)(this, "http", void 0);
    this.http = http;
  }
  async getInstallationStatus(params) {
    var _params$inferenceId;
    const inferenceId = (_params$inferenceId = params === null || params === void 0 ? void 0 : params.inferenceId) !== null && _params$inferenceId !== void 0 ? _params$inferenceId : _inferenceCommon.defaultInferenceEndpoints.ELSER;
    const resourceType = params === null || params === void 0 ? void 0 : params.resourceType;
    const response = await this.http.get(_installation.INSTALLATION_STATUS_API_PATH, {
      query: {
        inferenceId,
        ...(resourceType ? {
          resourceType
        } : {})
      }
    });
    return response;
  }
  async install(params) {
    var _params$inferenceId2;
    const inferenceId = (_params$inferenceId2 = params === null || params === void 0 ? void 0 : params.inferenceId) !== null && _params$inferenceId2 !== void 0 ? _params$inferenceId2 : _inferenceCommon.defaultInferenceEndpoints.ELSER;
    const resourceType = params === null || params === void 0 ? void 0 : params.resourceType;
    const response = await this.http.post(_installation.INSTALL_ALL_API_PATH, {
      body: JSON.stringify({
        inferenceId,
        ...(resourceType ? {
          resourceType
        } : {})
      })
    });
    if (!(response !== null && response !== void 0 && response.installed)) {
      throw new Error(`Installation did not complete successfully.${response.failureReason ? `\n${response.failureReason}` : ''}`);
    }
    return response;
  }
  async uninstall(params) {
    var _params$inferenceId3;
    const inferenceId = (_params$inferenceId3 = params === null || params === void 0 ? void 0 : params.inferenceId) !== null && _params$inferenceId3 !== void 0 ? _params$inferenceId3 : _inferenceCommon.defaultInferenceEndpoints.ELSER;
    const resourceType = params === null || params === void 0 ? void 0 : params.resourceType;
    const response = await this.http.post(_installation.UNINSTALL_ALL_API_PATH, {
      body: JSON.stringify({
        inferenceId,
        ...(resourceType ? {
          resourceType
        } : {})
      })
    });
    return response;
  }

  /**
   * Update all product documentation to the latest version.
   *
   * @param forceUpdate - If true, the docs with the same version majorMinor version will be forced to updated regardless
   * @param inferenceIds - If provided, only the product docs for the given inference IDs will be updated. If not, all previously installed inference IDs will be updated.
   * @returns
   */
  async updateAll(params) {
    var _params$forceUpdate, _params$inferenceIds;
    const forceUpdate = (_params$forceUpdate = params === null || params === void 0 ? void 0 : params.forceUpdate) !== null && _params$forceUpdate !== void 0 ? _params$forceUpdate : false;
    const inferenceIds = (_params$inferenceIds = params === null || params === void 0 ? void 0 : params.inferenceIds) !== null && _params$inferenceIds !== void 0 ? _params$inferenceIds : [];
    const response = await this.http.post(_installation.UPDATE_ALL_API_PATH, {
      body: JSON.stringify({
        forceUpdate,
        ...(inferenceIds.length > 0 ? {
          inferenceIds
        } : {})
      })
    });
    return response;
  }
}
exports.InstallationService = InstallationService;