"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInstallProductDoc = useInstallProductDoc;
var _reactQuery = require("@kbn/react-query");
var _inferenceCommon = require("@kbn/inference-common");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to install product documentation.
 * Automatically invalidates the status query on success.
 */
function useInstallProductDoc(productDocBase, options = {}) {
  const {
    onSuccess,
    onError
  } = options;
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _reactQuery.useMutation)([_constants.REACT_QUERY_KEYS.INSTALL_PRODUCT_DOC], async vars => {
    var _vars$inferenceId;
    const inferenceId = typeof vars === 'string' ? vars : (_vars$inferenceId = vars === null || vars === void 0 ? void 0 : vars.inferenceId) !== null && _vars$inferenceId !== void 0 ? _vars$inferenceId : _inferenceCommon.defaultInferenceEndpoints.ELSER;
    const resourceType = typeof vars === 'string' ? undefined : vars === null || vars === void 0 ? void 0 : vars.resourceType;
    return productDocBase.installation.install({
      inferenceId,
      resourceType
    });
  }, {
    onSuccess: () => {
      queryClient.invalidateQueries({
        queryKey: [_constants.REACT_QUERY_KEYS.GET_PRODUCT_DOC_STATUS],
        refetchType: 'all'
      });
      onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess();
    },
    onError
  });
}