"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PresentationUtilPlugin = void 0;
var _ = require(".");
var _kibana_services = require("./services/kibana_services");
var _presentation_labs_service = require("./services/presentation_labs_service");
var _panel_placement = require("./registries/panel_placement");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class PresentationUtilPlugin {
  setup(_coreSetup, _setupPlugins) {
    return {};
  }
  start(coreStart, startPlugins) {
    (0, _kibana_services.setKibanaServices)(coreStart, startPlugins);
    return {
      labsService: (0, _presentation_labs_service.getPresentationLabsService)(),
      registerExpressionsLanguage: _.registerExpressionsLanguage,
      registerPanelPlacementSettings: _panel_placement.registerPanelPlacementSettings,
      getPanelPlacementSettings: _panel_placement.getPanelPlacementSettings
    };
  }
  stop() {}
}
exports.PresentationUtilPlugin = PresentationUtilPlugin;