"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PresentationPanelHeader = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _presentation_panel_title = require("./presentation_panel_title");
var _use_presentation_panel_header_actions = require("./use_presentation_panel_header_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/presentation_panel/public/panel_component/panel_header/presentation_panel_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PresentationPanelHeader = ({
  api,
  viewMode,
  headerId,
  getActions,
  hideTitle,
  panelTitle,
  panelDescription,
  setDragHandle,
  showBadges = true,
  showNotifications = true
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    notificationElements,
    badgeElements
  } = (0, _use_presentation_panel_header_actions.usePresentationPanelHeaderActions)(showNotifications, showBadges, api, getActions);
  const memoizedSetDragHandle = (0, _react2.useCallback)(
  // memoize the ref callback so that we don't call `setDragHandle` on every render
  ref => {
    setDragHandle('panelHeader', ref);
  }, [setDragHandle]);
  const {
    captionStyles,
    headerStyles
  } = (0, _react2.useMemo)(() => {
    return {
      captionStyles: (0, _react.css)`
        .dshLayout--editing &:hover {
          cursor: move;
          background-color: ${(0, _eui.transparentize)(euiTheme.colors.warning, 0.2)};
        }
      `,
      headerStyles: (0, _react.css)`
        height: ${euiTheme.size.l};
        overflow: hidden;
        line-height: ${euiTheme.size.l};
        padding: 0px ${euiTheme.size.s};

        display: flex;
        flex-wrap: nowrap;
        column-gap: ${euiTheme.size.s};
        align-items: center;
        // all direct children now share the available parent width equally, ensuring consistent layout regardless of their content length
        > * {
          min-width: 0;
          flex: 1 !important;
          max-width: fit-content !important;
        }
      `
    };
  }, [euiTheme.colors.warning, euiTheme.size]);
  const showPanelBar = !hideTitle && panelTitle || badgeElements.length > 0 || notificationElements.length > 0;
  if (!showPanelBar) return null;
  return /*#__PURE__*/_react2.default.createElement("figcaption", {
    "data-test-subj": `embeddablePanelHeading-${(panelTitle || '').replace(/\s/g, '')}`,
    className: 'embPanel__header',
    css: captionStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    className: "embPanel__title",
    ref: memoizedSetDragHandle,
    "data-test-subj": "dashboardPanelTitle",
    css: headerStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_presentation_panel_title.PresentationPanelTitle, {
    api: api,
    headerId: headerId,
    viewMode: viewMode,
    hideTitle: hideTitle,
    panelTitle: panelTitle,
    panelDescription: panelDescription,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }), showBadges && badgeElements), showNotifications && notificationElements);
};
exports.PresentationPanelHeader = PresentationPanelHeader;