"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KbnPalettes = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
var _palettes = /*#__PURE__*/new WeakMap();
var _aliasMappings = /*#__PURE__*/new WeakMap();
var _defaultPalette = /*#__PURE__*/new WeakMap();
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class KbnPalettes {
  constructor(palettes, defaultPalette) {
    _classPrivateFieldInitSpec(this, _palettes, void 0);
    _classPrivateFieldInitSpec(this, _aliasMappings, void 0);
    _classPrivateFieldInitSpec(this, _defaultPalette, void 0);
    (0, _defineProperty2.default)(this, "query", id => {
      var _ref;
      const aliasedId = (_ref = _classPrivateFieldGet(_palettes, this).has(id) ? id : _classPrivateFieldGet(_aliasMappings, this).get(id)) !== null && _ref !== void 0 ? _ref : id;
      return _classPrivateFieldGet(_palettes, this).get(aliasedId);
    });
    (0, _defineProperty2.default)(this, "get", id => {
      var _this$query;
      return (_this$query = this.query(id)) !== null && _this$query !== void 0 ? _this$query : _classPrivateFieldGet(_defaultPalette, this);
    });
    (0, _defineProperty2.default)(this, "getAll", () => {
      return [..._classPrivateFieldGet(_palettes, this).values()].filter(({
        standalone
      }) => !standalone);
    });
    _classPrivateFieldSet(_defaultPalette, this, defaultPalette);
    _classPrivateFieldSet(_palettes, this, new Map(palettes.map(p => [p.id, p])));
    _classPrivateFieldSet(_aliasMappings, this, buildAliasMappings(palettes));
  }
}
exports.KbnPalettes = KbnPalettes;
function buildAliasMappings(palettes) {
  return palettes.reduce((acc, {
    id,
    aliases
  }) => {
    aliases.forEach(alias => {
      if (!acc.has(alias)) acc.set(alias, id);
    });
    return acc;
  }, new Map());
}